<?php
    $wishlistCourses = userAuth()
        ->favoriteCourses()
        ->with('category.translation', 'instructor:id,name')
        ->withCount([
            'reviews as avg_rating' => function ($query) {
                $query->select(DB::raw('coalesce(avg(rating), 0)'));
            },
        ])
        ->withCount([
            'lessons' => function ($query) {
                $query->where('status', 'active');
            },
        ])
        ->withCount('enrollments')
        ->paginate(3);
?>
<div class="row">
    <?php $__empty_1 = true; $__currentLoopData = $wishlistCourses ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col-md-4">
            <div class="courses__item-four shine__animate-item">
                <div class="courses__item-thumb-three shine__animate-link">
                    <a href="<?php echo e(route('course.show', $course->slug)); ?>"><img
                            src="<?php echo e(asset($course->thumbnail)); ?>" alt="img"></a>
                    <?php if($course->price == 0): ?>
                        <span class="courses__price"><?php echo e(__('Free')); ?></span>
                    <?php elseif($course->price > 0 && $course->discount > 0): ?>
                        <span class="courses__price"><?php echo e(currency($course->discount)); ?></span>
                    <?php else: ?>
                        <span class="courses__price"><?php echo e(currency($course->price)); ?></span>
                    <?php endif; ?>
                </div>
                <div class="courses__item-content-three">
                    <ul class="courses__item-meta list-wrap">
                        <li class="courses__item-tag">
                            <a
                                href="<?php echo e(route('courses', ['category' => $course->category->id])); ?>"><?php echo e($course->category?->name); ?></a>
                        </li>
                        <li class="courses__wishlist">
                            <a href="javascript:;" class="wsus-wishlist-remove"
                                data-slug="<?php echo e($course?->slug); ?>">
                                <img src="<?php echo e(asset('uploads/website-images/trash.svg')); ?>">
                            </a>
                        </li>
                    </ul>
                    <h2 class="title"><a
                            href="<?php echo e(route('course.show', $course->slug)); ?>"><?php echo e(truncate($course->title, 50)); ?></a>
                    </h2>
                    <div class="courses__review">
                        <div class="rating">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                        </div>
                        <span>(<?php echo e(number_format($course->avg_rating, 1) ?? 0); ?>

                            <?php echo e(__('Reviews')); ?>)</span>
                    </div>
                    <div class="courses__item-bottom-three">
                        <ul class="list-wrap">
                            <li><i class="flaticon-book"></i><?php echo e(__('Lessons')); ?>

                                <?php echo e($course?->lessons_count); ?></li>
                            <li><i class="flaticon-mortarboard"></i><?php echo e(__('Students')); ?>

                                <?php echo e($course?->enrollments_count); ?></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <h6 class="text-center"><?php echo e(__('No Course Found')); ?></h6>
    <?php endif; ?>
</div>
<nav class="wishlist pagination__wrap mt-25">
    <?php echo e($wishlistCourses->links()); ?>

</nav><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\wishlist\wishlist-card.blade.php ENDPATH**/ ?>