<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Settings')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Settings')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Settings')); ?></div>
                </div>
            </div>

            <div class="section-body">
                <div class="row">
                    <?php if(Module::isEnabled('GlobalSetting') && checkAdminHasPermission('setting.view')): ?>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-cog"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('General Setting')); ?></h4>
                                    <a href="<?php echo e(route('admin.general-setting')); ?>"
                                        class="card-cta"><?php echo e(__('Change Setting')); ?>

                                        <i class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-envelope"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('Email Configuration')); ?></h4>
                                    <a href="<?php echo e(route('admin.email-configuration')); ?>"
                                        class="card-cta"><?php echo e(__('Change Setting')); ?> <i
                                            class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-key"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('Credential Settings')); ?></h4>
                                    <a href="<?php echo e(route('admin.crediential-setting')); ?>"
                                        class="card-cta"><?php echo e(__('Change Setting')); ?> <i
                                            class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-arrow-circle-up"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('System Update')); ?></h4>
                                    <a href="<?php echo e(route('admin.system-update.index')); ?>"
                                        class="card-cta"><?php echo e(__('Change Setting')); ?> <i
                                            class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-money-bill"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('Admin Commission')); ?></h4>
                                    <a href="<?php echo e(route('admin.commission-setting')); ?>"
                                        class="card-cta"><?php echo e(__('Change Setting')); ?> <i
                                            class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(Module::isEnabled('GlobalSetting') && checkAdminHasPermission('addon.view')): ?>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="text-white card-icon bg-primary">
                                    <i class="fas fa-plug"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('Manage Addons')); ?></h4>
                                    <a class="card-cta" href="<?php echo e(route('admin.addons.view')); ?>"><?php echo e(__('Change Setting')); ?>

                                        <i class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(auth()->guard('admin')->user()->can('currency.view')): ?>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-coins"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('Multi Currency')); ?></h4>
                                    <a href="<?php echo e(route('admin.currency.index')); ?>" class="card-cta"><?php echo e(__('Change Setting')); ?>

                                        <i class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(auth()->guard('admin')->user()->can('language.view')): ?>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-language"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('Manage Language')); ?></h4>
                                    <a href="<?php echo e(route('admin.languages.index')); ?>" class="card-cta"><?php echo e(__('Change Setting')); ?>

                                        <i class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(checkAdminHasPermission('basic.payment.view')): ?>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-credit-card"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('Payment Gateway')); ?></h4>
                                    <a href="<?php echo e(route('admin.basicpayment')); ?>"
                                        class="card-cta"><?php echo e(__('Change Setting')); ?> <i
                                            class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(checkAdminHasPermission('admin.view') || checkAdminHasPermission('role.view')): ?>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-shield-alt"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('Admin & Roles')); ?></h4>
                                    <a href="<?php echo e(route('admin.admin.index')); ?>" class="card-cta"><?php echo e(__('Change Setting')); ?>

                                        <i class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <?php if(Module::isEnabled('GlobalSetting') && checkAdminHasPermission('setting.view')): ?>
                        <div class="col-lg-6">
                            <div class="card card-large-icons">
                                <div class="card-icon bg-primary text-white">
                                    <i class="fas fa-ad"></i>
                                </div>
                                <div class="card-body">
                                    <h4><?php echo e(__('Marketing Settings')); ?></h4>
                                    <a href="<?php echo e(route('admin.marketing-setting')); ?>"
                                        class="card-cta"><?php echo e(__('Change Setting')); ?>

                                        <i class="fas fa-chevron-right"></i></a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\admin\settings\settings.blade.php ENDPATH**/ ?>