<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap">

        <div class="dashboard__content-title d-flex justify-content-between">
            <h4 class="title"><?php echo e(__('Create Course')); ?></h4>
        </div>
        <div class="row">
            <div class="col-12">
                <?php echo $__env->make('frontend.instructor-dashboard.course.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="instructor__profile-form-wrap">
                    <form action="<?php echo e(route('instructor.courses.update')); ?>" class="instructor__profile-form course-form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="course_id" id="" value="<?php echo e($course->id); ?>">
                        <input type="hidden" name="step" id="" value="5">
                        <input type="hidden" name="next_step" value="5">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-grp">
                                    <label for=""><?php echo e(__('Message for Reviewer')); ?> <code></code></label>
                                    <textarea name="message_for_reviewer" class="form-control"><?php echo e($course->message_for_reviewer); ?></textarea>
                                </div>
                            </div>

                            <div class="col-md-12">
                              <div class="form-grp">
                                  <label for=""><?php echo e(__('Status')); ?> <code>*</code></label>
                                  <select name="status" id="" class="form-select">
                                    <option value=""><?php echo e(__('Select')); ?></option>
                                    <option <?php if($course->status == 'active'): echo 'selected'; endif; ?> value="active"><?php echo e(__('Publish')); ?></option>
                                    <option <?php if($course->status == 'inactive'): echo 'selected'; endif; ?> value="inactive"><?php echo e(__('UnPublish')); ?></option>
                                    <option <?php if($course->status == 'is_draft'): echo 'selected'; endif; ?> value="is_draft"><?php echo e(__('Draft')); ?></option>
                                  </select>
                              </div>
                          </div>

                            <div>
                                <button class="btn btn-primary" type="submit"><?php echo e(__('Save')); ?></button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('frontend/js/default/courses.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.instructor-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\course\finish.blade.php ENDPATH**/ ?>