<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Courses')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1 class=""><?php echo e(__('Courses')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Courses List')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.course.index')); ?>" method="GET"
                                    onchange="$(this).trigger('submit')" class="form_padding">
                                    <div class="row">
                                        <div class="col-md-3 form-group">
                                            <input type="text" name="keyword" value="<?php echo e(request()->get('keyword')); ?>"
                                                class="form-control" placeholder="<?php echo e(__('Search')); ?>">
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <input type="text" autocomplete="off" name="date" value="<?php echo e(request()->get('date')); ?>"
                                                class="form-control datepicker" placeholder="<?php echo e(__('Date')); ?>">
                                        </div>
                                        <div class="col-md-3">
                                            <div class="from-group">
                                                <select class="select2 form-group category" name="category">
                                                    <option value=""><?php echo e(__('Category')); ?></option>
                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <optgroup label="<?php echo e($category->translation?->name); ?>">
                                                            <?php $__currentLoopData = $category->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option value="<?php echo e($subCategory->id); ?>"
                                                                    <?php echo e(request()->get('category') == $subCategory->id ? 'selected' : ''); ?>>
                                                                    <?php echo e($subCategory->translation?->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </optgroup>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <select name="instructor" id="instructor" class="form-control select2">

                                                <option value=""><?php echo e(__('Instructor')); ?></option>
                                                <?php $__currentLoopData = $instructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($instructor->id); ?>" <?php echo e(request()->get('instructor') == $instructor->id ? 'selected' : ''); ?>>
                                                        <?php echo e($instructor->name); ?> (<?php echo e($instructor->email); ?>)</option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                                                
                                            </select>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <select name="approve_status" id="" class="form-control">
                                                <option value=""><?php echo e(__('Approval Status')); ?></option>
                                                <option
                                                    <?php echo e(request()->get('approve_status') == 'pending' ? 'selected' : ''); ?>

                                                    value="pending"><?php echo e(__('Pending')); ?></option>
                                                <option
                                                    <?php echo e(request()->get('approve_status') == 'approved' ? 'selected' : ''); ?>

                                                    value="approved"><?php echo e(__('Approved')); ?></option>
                                                <option
                                                    <?php echo e(request()->get('approve_status') == 'rejected' ? 'selected' : ''); ?>

                                                    value="rejected"><?php echo e(__('Rejected')); ?></option>
                                            </select>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <select name="status" id="status" class="form-control">
                                                <option value=""><?php echo e(__('Status')); ?></option>
                                                <option <?php echo e(request()->get('status') == 'active' ? 'selected' : ''); ?>

                                                    value="active"><?php echo e(__('Published')); ?></option>
                                                <option <?php echo e(request()->get('status') == 'inactive' ? 'selected' : ''); ?>

                                                    value="inactive"><?php echo e(__('Unpublished')); ?></option>
                                                <option <?php echo e(request()->get('status') == 'draft' ? 'selected' : ''); ?>

                                                    value="draft"><?php echo e(__('Drafted')); ?></option>
                                            </select>
                                        </div>

                                        <div class="col-md-3 form-group">
                                            <select name="order_by" id="order_by" class="form-control">
                                                <option value=""><?php echo e(__('Order By')); ?></option>
                                                <option value="1" <?php echo e(request('order_by') == '1' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('ASC')); ?>

                                                </option>
                                                <option value="0" <?php echo e(request('order_by') == '0' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('DESC')); ?>

                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <select name="par_page" id="par-page" class="form-control">
                                                <option value=""><?php echo e(__('Per Page')); ?></option>
                                                <option value="10" <?php echo e('10' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('10')); ?>

                                                </option>
                                                <option value="50" <?php echo e('50' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('50')); ?>

                                                </option>
                                                <option value="100"
                                                    <?php echo e('100' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('100')); ?>

                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Courses List')); ?></h4>
                                <div>
                                    <a href="<?php echo e(route('admin.courses.create')); ?>" class="btn btn-primary"> <i
                                            class="fa fa-plus"></i><?php echo e(__('Add New')); ?></a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive max-h-400">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('SN')); ?></th>
                                                <th class="course-table-title"><?php echo e(__('Title')); ?></th>
                                                <th><?php echo e(__('Instructor')); ?></th>
                                                <th><?php echo e(__('Price')); ?></th>
                                                <th><?php echo e(__('Students')); ?></th>
                                                <th><?php echo e(__('Created Date')); ?></th>
                                                <th><?php echo e(__('Update Date')); ?></th>
                                                <th><?php echo e(__('Status')); ?></th>
                                                <th class="course-table-approve"><?php echo e(__('Approve')); ?></th>
                                                <th class="text-center"><?php echo e(__('Actions')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $courses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e($loop->index + 1); ?></td>
                                                    <td class="course-table-title">
                                                        <span><?php echo e(truncate($course->title)); ?></span>
                                                        <br>
                                                        <small><?php echo e($course->category->translation->name ?? ''); ?></small>
                                                    </td>
                                                    <td><?php echo e($course->instructor->name ?? ''); ?></td>
                                                    <td>
                                                        <?php if($course->price == 0): ?>
                                                            <span><?php echo e(__('Free')); ?></span>
                                                        <?php elseif($course->discount > 0): ?>
                                                            <?php echo e(currency($course->discount)); ?>

                                                        <?php else: ?>
                                                            <?php echo e(currency($course->price)); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td><?php echo e($course->enrollments_count); ?></td>
                                                    <td><small><?php echo e(formatDate($course->created_at)); ?></small>
                                                        <br>
                                                        <small><?php echo e(formatDate($course->created_at, 'H:i')); ?></small>
                                                    </td>
                                                    <td><small><?php echo e(formatDate($course->updated_at)); ?></small>
                                                        <br>
                                                        <small><?php echo e(formatDate($course->updated_at, 'H:i')); ?></small>
                                                    </td>
                                                    <td>
                                                        <?php if($course->status == 'active'): ?>
                                                            <span class="badge badge-success"><?php echo e(__('Published')); ?></span>
                                                        <?php elseif($course->status == 'inactive'): ?>
                                                            <span class="badge badge-danger"><?php echo e(__('Unpublished')); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge badge-warning"><?php echo e(__('draft')); ?></span>
                                                        <?php endif; ?>
                                                    </td>

                                                    <td class="course-table-approve">
                                                        <select name="" class="form-control course-change-status"
                                                            data-id="<?php echo e($course->id); ?>">
                                                            <option <?php if($course->is_approved == 'pending'): echo 'selected'; endif; ?> value="pending">
                                                                <?php echo e(__('Pending')); ?></option>
                                                            <option <?php if($course->is_approved == 'approved'): echo 'selected'; endif; ?> value="approved">
                                                                <?php echo e(__('Approved')); ?></option>
                                                            <option <?php if($course->is_approved == 'rejected'): echo 'selected'; endif; ?> value="rejected">
                                                                <?php echo e(__('Rejected')); ?></option>
                                                        </select>
                                                    </td>

                                                    <td class="text-center">
                                                        <div>
                                                            <div class="dropdown">
                                                                <button class="btn btn-primary dropdown-toggle"
                                                                    type="button" id="dropdownMenu2" data-toggle="dropdown"
                                                                    aria-haspopup="true" aria-expanded="false">
                                                                    <i class="fa fa-ellipsis-v"></i>
                                                                </button>
                                                                <div class="dropdown-menu" aria-labelledby="dropdownMenu2">
                                                                    <a href="<?php echo e(route('admin.courses.edit-view', $course->id)); ?>"
                                                                        class="dropdown-item"
                                                                        target="_blank"><?php echo e(__('Edit')); ?></a>

                                                                    <a href="<?php echo e(route('admin.courses.destroy', $course->id)); ?>"
                                                                        class="dropdown-item text-danger delete-item"><?php echo e(__('Delete')); ?></a>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __('Couse Filter'),'route' => 'admin.course-filter.create','create' => 'no','message' => __('No data found!'),'colspan' => '11'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="float-right">
                                    <?php echo e($courses->links()); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('global/js/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/default/courses.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/sweetalert.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules/Course\resources/views/course/index.blade.php ENDPATH**/ ?>