<?php
    $pendingRequestCount = \Modules\InstructorRequest\app\Models\InstructorRequest::where('status', 'pending')->count();
?>
<li
    class="nav-item dropdown <?php echo e(isRoute(['admin.instructor-request-setting.*', 'admin.instructor-request.*'], 'active')); ?>">
    <a href="javascript:void()" class="nav-link has-dropdown"><i class="fas fa-chalkboard-teacher"></i><span
            class="<?php echo e($pendingRequestCount > 0 ? 'beep parent' : ''); ?>"><?php echo e(__('Instructor Requests')); ?></span></a>

    <ul class="dropdown-menu">
        <li class="<?php echo e(isRoute('admin.instructor-request.*', 'active')); ?>">
            <a class="nav-link" href="<?php echo e(route('admin.instructor-request.index')); ?>">
                <?php echo e(__('Request List')); ?>

                <?php if($pendingRequestCount > 0): ?>
                    <small class="badge badge-danger ml-2"><?php echo e($pendingRequestCount); ?></small>
                <?php endif; ?>
            </a>
        </li>

        <li class="<?php echo e(isRoute('admin.instructor-request-setting.*', 'active')); ?>">
            <a class="nav-link" href="<?php echo e(route('admin.instructor-request-setting.index', ['code' => 'en'])); ?>">
                <?php echo e(__('Request Settings')); ?>

            </a>
        </li>

    </ul>
</li>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\InstructorRequest\resources\views\sidebar.blade.php ENDPATH**/ ?>