<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Custom CSS & JS')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.settings')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Custom CSS & JS')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.settings')); ?>"><?php echo e(__('Settings')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Custom CSS & JS')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="col">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 col-sm-12">
                                    <div class="border rounded">
                                        <div class="m-0 card">
                                            <div class="card-body">
                                                <form action="<?php echo e(route('admin.update-custom-code')); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="row">
                                                        <div class="col-12">
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('Custom CSS')); ?></label>
                                                                <textarea name="css" id="css-editor" cols="30" rows="5" class="form-control text-area-5"><?php echo e(old('css', $customCode->css)); ?></textarea>
                                                            </div>
                                                        </div>
                                                        <div class="col-12">
                                                            <div class="form-group">
                                                                <label for=""><?php echo e(__('Custom JS')); ?></label>
                                                                <textarea name="javascript" id="js-editor" cols="30" rows="5" class="form-control text-area-5"><?php echo e(old('javascript', $customCode->javascript)); ?></textarea>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <button type="submit"
                                                        class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/codemirror/codemirror.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/codemirror/codemirror.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/codemirror/javascript.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/codemirror/css.js')); ?>"></script>

    <script>
        var editor = CodeMirror.fromTextArea(document.getElementById('css-editor'), {
            mode: "css",
            lineNumbers: true,
            lineWrapping: true,
            autocorrect: true,
        });
        editor.save()
        var editorJs = CodeMirror.fromTextArea(document.getElementById('js-editor'), {
            mode: "javascript",
            lineNumbers: true,
            lineWrapping: true,
            autocorrect: true,
        });
        editorJs.save()
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\GlobalSetting\resources\views\custom_code.blade.php ENDPATH**/ ?>