<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e(__('Invoice')); ?></title>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .invoice_area {
            font-family: sans-serif;
        }

        .invoice_area table {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
        }

        .invoice_area table tbody {
            width: 100%;
        }

        .invoice_area table tr {
            width: 100% !important;
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
        }

        .invoice_area table tr td {
            text-transform: capitalize;
            font-size: 16px;
        }

        .invoice_header {
            background: #f3f2f2;
            padding: 30px;
        }

        .invoice_header table tr td {
            width: 49%;
        }

        .invoice_header table tr td.left a {
            display: block;
            width: 160px;
        }

        .invoice_header table tr td.right h2 {
            text-transform: uppercase;
            font-size: 28px;
            font-weight: 600;
            line-height: initial;
            margin-bottom: 10px;
            text-align: right;
            color: #05092B;
        }

        .invoice_header table tr td.right h5 {
            font-size: 16px;
            text-align: right;
            color: #05092B;
        }

        .invoice_billing_info {
            padding: 30px;
        }

        .invoice_billing_info table tr td h5 {
            font-size: 20px;
            font-weight: 700;
            text-transform: capitalize;
            margin-bottom: 10px;
            color: #05092B;
        }

        .invoice_billing_info table tr td p {
            color: #545353;
            font-weight: 400;
            font-size: 16px;
            margin-top: 10px;
        }

        .invoice_billing_info .right p {
            text-align: right;
        }

        .invoice_billing_info .right p span {
            display: inline-block;
            width: 70px;
            text-align: right;
        }

        .invoice_billing_info .right p:last-child,
        .invoice_billing_info .right p:last-child span {
            font-weight: 600;
        }

        .invoice_billing_order {
            padding: 30px;
        }

        .invoice_billing_order table {
            border: 1px solid rgb(238, 238, 238);
        }

        .invoice_billing_order table thead {
            width: 100%;
        }

        .invoice_billing_order table thead tr {
            background: #f3f2f2;
        }

        .invoice_billing_order table thead tr th {
            background: #f3f2f2;
        }

        .invoice_billing_order table tr th,
        .invoice_billing_order table tr td {
            padding: 10px 20px;
            border-right: 1px solid rgb(238, 238, 238);
            border-bottom: 1px solid rgb(238, 238, 238);
            width: 25%;
            color: #05092B;
            text-align: left;
        }

        .sl-no {
            width: 10% !important;
        }

        .item {
            width: 40% !important;
        }

        .by {
            width: 35% !important;
        }

        .price {
            width: 15% !important;
        }

        .invoice_billing_info .right p span {
            display: inline-block;
            width: 150px !important;
            text-align: right;
        }
    </style>
</head>

<body>

    <div class="invoice_area">

        <div class="invoice_header">
            <div class="table-responsive">
                <table class="table">
                    <tbody>
                        <tr>
                            <td class="left">
                                <a href="javascript:;">
                                    <img src="<?php echo e(asset($setting->logo)); ?>" alt="">
                                </a>
                                <?php if($order->isBundleOrder()): ?>
                                    <br>
                                    <h5><?php echo e(__('Bundle Name')); ?>: <?php echo e($order?->order_details?->title); ?></h5>
                                <?php endif; ?>
                                <?php if($order->isGiftOrder()): ?>
                                    <br>
                                    <address>
                                        <strong><?php echo e(__('Gift')); ?>:</strong><br>
                                        <span><?php echo e(__('Recipient Name')); ?>:</span>
                                        <?php echo e($order?->order_details?->recipient_name); ?><br>
                                        <span><?php echo e(__('Recipient Email')); ?>:</span>
                                        <?php echo e($order?->order_details?->recipient_email); ?><br>
                                        <?php echo e(__('Status')); ?>: 
                                        <?php if(empty($order?->order_details?->verification_token)): ?>
                                            <span><?php echo e(__('Claimed')); ?></span>
                                        <?php else: ?>
                                            <span><?php echo e(__('Pending')); ?></span>
                                        <?php endif; ?>
                                    </address>
                                <?php endif; ?>
                            </td>
                            <td class="right">
                                <h2><?php echo e(__('invoice')); ?></h2>
                                <h5><?php echo e(__('Order Id: ')); ?><?php echo e($order->invoice_id); ?></h5>
                                <br>
                                <h5><?php echo e(__('Date: ')); ?><?php echo e(formatDate($order->created_at)); ?></h5>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="invoice_billing_info">
            <div class="table-responsive">
                <table class="table">
                    <tbody>
                        <tr>
                            <td>
                                <h5><?php echo e(__('Billed To')); ?></h5>
                                <p><?php echo e($order->user->name); ?></p>
                                <p><?php echo e($order->user->phone); ?></p>
                                <p><?php echo e($order->user->email); ?></p>
                                <p><?php echo e($order->user->address); ?></p>

                            </td>
                            <td>
                                <h5><?php echo e(__('Billed From')); ?></h5>
                                <p><?php echo e($setting->app_name); ?></p>
                                <p><?php echo e($setting->contact_message_receiver_mail); ?></p>
                                <p><?php echo e($setting->site_address); ?></p>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="invoice_billing_order">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th class="sl-no"><?php echo e(__('No')); ?>.</th>
                            <th class="item"><?php echo e(__('Item')); ?></th>
                            <th class="by"><?php echo e(__('By')); ?></th>
                            <th class="price"><?php echo e(__('Price')); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $order->orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="sl-no"><?php echo e($loop->iteration); ?></td>
                                <td class="item"><?php echo e($item->course->title); ?></td>
                                <td class="by">
                                    <?php echo e($item->course->instructor->name); ?>

                                    <br>
                                    <small><?php echo e($item->course->instructor->email); ?></small>
                                </td>
                                <td class="price">
                                    <?php if($order->isBundleOrder()): ?>
                                        --
                                    <?php else: ?>
                                        <?php echo e($item->price * $order->conversion_rate); ?>

                                        <?php echo e($order->payable_currency); ?>

                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="invoice_billing_info">
            <div class="table-responsive">
                <table class="table">
                    <tbody>
                        <tr>
                            <td class="left">
                                <h5><?php echo e(__('Payment Details')); ?></h5>
                                <p><b><?php echo e(__('Payment Method')); ?> :</b> <?php echo e($order->payment_method); ?></p>
                                <p><b><?php echo e(__('Payment Status')); ?> :</b> <?php echo e($order->payment_status); ?></p>
                            </td>
                            <td class="right">
                                <?php if($order->isBundleOrder()): ?>
                                    <?php
                                        $subTotal = $order->payable_amount;
                                        $subTotalWithCharge = $order->payable_amount * $order->conversion_rate;
                                        $gatewayCharge = 0;
                                        if ($order->gateway_charge > 0) {
                                            $gatewayCharge = ($order->gateway_charge / $subTotalWithCharge) * 100;
                                        }
                                        $total = number_format($subTotalWithCharge + $order->gateway_charge, 2);
                                    ?>
                                    <p><?php echo e(__('Sub Total')); ?>

                                        :<span><?php echo e(number_format($subTotal * $order->conversion_rate, 2)); ?>

                                        </span> <?php echo e($order->payable_currency); ?></p>
                                    <p><?php echo e(__('Gateway Charge')); ?>

                                        (<?php echo e($gatewayCharge); ?>%):<span> <?php echo e(number_format($order->gateway_charge, 2)); ?>

                                            <?php echo e($order->payable_currency); ?></span> </p>
                                    <p><?php echo e(__('Total')); ?> :<span><?php echo e($total); ?>

                                        </span> <?php echo e($order->payable_currency); ?></p>
                                <?php else: ?>
                                    <?php
                                        $subTotal = 0;
                                        $discount = 0;
                                        $gatewayCharge = 0;
                                        foreach ($order->orderItems as $item) {
                                            $subTotal += $item->price;
                                        }
                                        $subTotalWithConversion = $subTotal * $order->conversion_rate;

                                        if ($order->coupon_discount_amount > 0) {
                                            $discount = $order->coupon_discount_amount;
                                        }

                                        if ($order->gateway_charge > 0) {
                                            $gatewayCharge =
                                                ($order->gateway_charge / ($subTotalWithConversion - $discount)) * 100;
                                        }

                                        $total = number_format(
                                            $subTotalWithConversion - $discount + $order->gateway_charge,
                                            2,
                                        );
                                    ?>

                                    <p><?php echo e(__('Sub Total')); ?>

                                        :<span><?php echo e(number_format($subTotal * $order->conversion_rate, 2)); ?>

                                        </span> <?php echo e($order->payable_currency); ?></p>
                                    <p><?php echo e(__('Discount')); ?>

                                        :<span><?php echo e(number_format($discount, 2)); ?>

                                            <?php echo e($order->payable_currency); ?></span></p>
                                    <p><?php echo e(__('Gateway Charge')); ?>

                                        (<?php echo e(number_format($gatewayCharge, 2)); ?>%)<span><?php echo e(number_format($order->gateway_charge, 2)); ?>

                                            <?php echo e($order->payable_currency); ?></span> </p>
                                    <p><?php echo e(__('Total')); ?> :<span><?php echo e($total); ?>

                                        </span> <?php echo e($order->payable_currency); ?></p>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>

    </div>


    <script>
        'use strict'
        // auto print the page
        window.addEventListener('load', window.print());
    </script>
</body>

</html>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\student-dashboard\order\invoice.blade.php ENDPATH**/ ?>