<div class="tab-pane fade show <?php echo e(session('profile_tab') == 'education' ? 'active' : ''); ?>" id="itemFive-tab-pane"
    role="tabpanel" aria-labelledby="itemFive-tab" tabindex="0">
    <!-- Experience -->
    <div class="instructor__profile-form-wrap">
        <div class="dashboard__content-title d-flex justify-content-between">
            <h4 class="title"><?php echo e(__('Experience')); ?></h4>
            <button type="button" class="btn btn-primary btn-hight-basic show-modal"
                data-url="<?php echo e(route('instructor.setting.experience-modal')); ?>">
                <?php echo e(__('Add Experience')); ?>

            </button>

        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table table-responsive">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th><?php echo e(__('No')); ?></th>
                                <th><?php echo e(__('Company')); ?></th>
                                
                                <th><?php echo e(__('Position')); ?></th>
                                <th><?php echo e(__('Start Date')); ?></th>
                                <th><?php echo e(__('End Date')); ?></th>
                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $experience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <p><?php echo e($loop->iteration); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e($experience->company); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e($experience->position); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e($experience->start_date); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e($experience->current == 1 ||$experience->end_date == null ? 'Present' : $experience->end_date); ?></p>
                                    </td>
                                    <td>
                                        <div class="dashboard__review-action">
                                            <a href="#" class="show-modal"
                                                data-url="<?php echo e(route('instructor.setting.edit-experience-modal', $experience->id)); ?>"
                                                title="Edit"><i class="far fa-edit"></i></i></a>
                                            <a href="<?php echo e(route('instructor.setting.experience.destroy', $experience->id)); ?>"
                                                class="delete-item" title="Delete"><i class="far fa-trash-alt"></i></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="6" class="text-center">
                                    <span class="text-muted"><?php echo e(__('No Data!')); ?></span>
                                </td>
                            <?php endif; ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <br>
    <br>
    <!-- Education -->
    <div class="instructor__profile-form-wrap">
        <div class="dashboard__content-title d-flex justify-content-between">
            <h4 class="title"><?php echo e(__('Education')); ?></h4>
            <button type="button" class="btn btn-primary btn-hight-basic show-modal"
                data-url="<?php echo e(route('instructor.setting.add-education-modal')); ?>">
                <?php echo e(__('Add Education')); ?>

            </button>

        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table table-responsive">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th><?php echo e(__('No')); ?></th>
                                <th><?php echo e(__('Organization')); ?></th>
                                <th><?php echo e(__('Degree')); ?></th>
                                <th><?php echo e(__('Start Date')); ?></th>
                                <th><?php echo e(__('End Date')); ?></th>
                                <th width="20%"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <p><?php echo e($loop->iteration); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e($education->organization); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e($education->degree); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e($education->start_date); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e($education->current || $education->end_date == null ? 'Present' : $education->end_date); ?></p>
                                    </td>

                                    <td>
                                        <div class="dashboard__review-action">
                                            <a href="#" class="show-modal"
                                                data-url="<?php echo e(route('instructor.setting.edit-education-modal', $education->id)); ?>"
                                                title="Edit"><i class="far fa-edit"></i></i></a>
                                            <a href="<?php echo e(route('instructor.setting.education.destroy', $education->id)); ?>"
                                                class="delete-item" title="Delete"><i class="far fa-trash-alt"></i></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="6" class="text-center">
                                    <span class="text-muted"><?php echo e(__('No Data!')); ?></span>
                                </td>
                            <?php endif; ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\profile\sections\education-and-experience.blade.php ENDPATH**/ ?>