<div class="tab-pane fade active show" id="stripe_payment_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.update-stripe')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for=""><?php echo e(__('Gateway charge (%)')); ?></label>
                    <input type="text" class="form-control" name="stripe_charge"
                        value="<?php echo e($basic_payment->stripe_charge); ?>">
                </div>
            </div>
        </div>

        <div class="form-group">
            <label for=""><?php echo e(__('Stripe Key')); ?></label>
            <?php if(env('APP_MODE') == 'DEMO'): ?>
                <input type="text" class="form-control" name="stripe_key" value="DEMO-STRIPE-83493483-TEST-KEY">
            <?php else: ?>
                <input type="text" class="form-control" name="stripe_key" value="<?php echo e($basic_payment->stripe_key); ?>">
            <?php endif; ?>

        </div>

        <div class="form-group">
            <label for=""><?php echo e(__('Stripe Secret')); ?></label>
            <?php if(env('APP_MODE') == 'DEMO'): ?>
                <input type="text" class="form-control" name="stripe_secret" value="STRIPE-TEST98384934-SECRET-KEY">
            <?php else: ?>
                <input type="text" class="form-control" name="stripe_secret"
                    value="<?php echo e($basic_payment->stripe_secret); ?>">
            <?php endif; ?>
        </div>
        <div class="form-group">
            <label><?php echo e(__('New Image')); ?> <code>(<?php echo e(__('Recommended')); ?>: 210X100 PX)</code></label>
            <div id="image-preview-stripe" class="image-preview">
                <label for="image-upload-stripe"
                    id="image-label-stripe"><?php echo e(__('Image')); ?></label>
                <input type="file" name="stripe_image" id="image-upload-stripe">
            </div>

        </div>
        <div class="form-group">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="stripe_status" class="custom-switch-input">
                <input type="checkbox" value="active" name="stripe_status" class="custom-switch-input"
                    <?php echo e($basic_payment?->stripe_status == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
            </label>
        </div>

        <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\sections\stripe.blade.php ENDPATH**/ ?>