<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Request Details')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Request Details')); ?></h1>
            </div>

            <div class="section-body">
                <div class="row">
                    <div class="col-xl-3">
                        <div class="card shadow">
                            <?php if($user->image): ?>
                                <img src="<?php echo e(asset($user->image)); ?>" class="profile_img w-100">
                            <?php else: ?>
                                <img src="<?php echo e(asset($setting->default_avatar)); ?>" class="w-100">
                            <?php endif; ?>
                            <hr>
                            <div class="container my-3">
                                <h4><?php echo e(html_decode($user->name)); ?></h4>

                                <?php if($user->phone): ?>
                                    <p class="title"><?php echo e(html_decode($user->phone)); ?></p>
                                <?php endif; ?>

                                <p class="title"><?php echo e(html_decode($user->email)); ?></p>

                                <p class="title"><?php echo e(__('Joined')); ?> : <?php echo e($user->created_at->format('h:iA, d M Y')); ?></p>


                                <?php if($user->email_verified_at): ?>
                                    <p class="title"><?php echo e(__('Email verified')); ?> : <b><?php echo e(__('Yes')); ?></b> </p>
                                <?php else: ?>
                                    <p class="title"><?php echo e(__('Email verified')); ?> : <b><?php echo e(__('NO')); ?></b> </p>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>

                    <div class="col-md-9">
                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="service_card"><?php echo e(__('Informations')); ?></h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td><b><?php echo e(__('Status')); ?></b></td>
                                            <td>
                                                <?php if($instructorRequest->status == 'pending'): ?>
                                                    <span class="badge badge-warning"><?php echo e(__('Pending')); ?></span>
                                                <?php elseif($instructorRequest->status == 'approved'): ?>
                                                    <span class="badge badge-success"><?php echo e(__('Approved')); ?></span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger"><?php echo e(__('Rejected')); ?></span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php if($instructorRequest->certificate): ?>
                                            <tr>
                                                <td><b><?php echo e(__('Certificate / Document')); ?></b></td>
                                                <td><a target="_blank" href="<?php echo e(asset($instructorRequest->certificate)); ?>"
                                                        class="btn btn-primary"><?php echo e(__('Download')); ?></a></td>
                                            </tr>
                                        <?php endif; ?>

                                        <?php if($instructorRequest->identity_scan): ?>
                                            <tr>
                                                <td><b><?php echo e(__('Identity Scan')); ?></b></td>
                                                <td><a target="_blank"
                                                        href="<?php echo e(asset($instructorRequest->identity_scan)); ?>"
                                                        class="btn btn-primary"><?php echo e(__('Download')); ?></a></td>
                                            </tr>
                                        <?php endif; ?>

                                        <tr>
                                            <td><b><?php echo e(__('Extra Informations')); ?></b></td>
                                            <td><?php echo e($instructorRequest->extra_information); ?></td>
                                        </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>

                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="service_card"><?php echo e(__('Payout Informations')); ?></h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td><b><?php echo e(__('Payout Account')); ?></b></td>
                                            <td><?php echo e($instructorRequest->payout_account); ?></td>
                                        </tr>
                                        <tr>
                                            <td><b><?php echo e(__('Payout Details')); ?></b></td>
                                            <td><?php echo nl2br(clean($instructorRequest->payout_information)); ?></td>
                                        </tr> 
                                    </tbody>
                                </table>
                            </div>
                        </div>

                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="service_card"><?php echo e(__('Informations')); ?></h5>
                            </div>
                            <div class="card-body">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td><b><?php echo e(__('Update Status')); ?></b></td>
                                            <td>
                                                <form action="<?php echo e(route('admin.instructor-request.update', $instructorRequest->id)); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('PUT'); ?>
                                                    <div class="form-group mt-3">
                                                        <select name="status" class="form-control">
                                                            <option <?php if($instructorRequest->status == 'pending'): echo 'selected'; endif; ?> value="pending">
                                                                <?php echo e(__('Pending')); ?></option>
                                                            <option <?php if($instructorRequest->status == 'approved'): echo 'selected'; endif; ?> value="approved">
                                                                <?php echo e(__('Approved')); ?></option>
                                                            <option <?php if($instructorRequest->status == 'rejected'): echo 'selected'; endif; ?> value="rejected">
                                                                <?php echo e(__('Rejected')); ?></option>
                                                        </select>
                                                        <button class="btn btn-success mt-2"
                                                            type="submit"><?php echo e(__('Update')); ?></button>
                                                    </div>
                                                </form>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\InstructorRequest\resources\views\instructor-request\edit.blade.php ENDPATH**/ ?>