<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Themes')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/css/colorpicker.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Themes')); ?></h1>
            </div>

            <div class="section-body">
                <div class="row">
                    <div class="col-md-12 col-lg-4">
                        <div class="card appearance_card_margin">
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.site-appearance.update', 1)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="form-group">
                                        <label><?php echo e(__('Select Theme')); ?></label>
                                        <?php use \App\Enums\ThemeList; ?>
                                        <select class="form-control" name="theme">
                                            <?php $__currentLoopData = ThemeList::cases(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php if(Cache::get('setting')?->site_theme == $theme->value): echo 'selected'; endif; ?> value="<?php echo e($theme->value); ?>">
                                                    <?php echo e(__($theme->value)); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                        <div class="form-group">
                                            <label class="custom-switch p-0 mt-1">
                                                <input type="checkbox" name="show_all_homepage" value="1"
                                                    class="custom-switch-input" <?php if($setting?->show_all_homepage == 1): echo 'checked'; endif; ?>>
                                                <span class="custom-switch-indicator"></span>
                                                <span
                                                    class="custom-switch-description"><?php echo e(__('Show all home pages')); ?></span>
                                            </label>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <h6 class="text-center"><?php echo e(__(ThemeList::MAIN->value)); ?></h6>
                        <div class="screen">
                            <img src="<?php echo e(asset('uploads/website-images/theme-one.png')); ?>">
                        </div>

                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <h6 class="text-center"><?php echo e(__(ThemeList::ONLINE->value)); ?></h6>
                        <div class="screen">
                            <img src="<?php echo e(asset('uploads/website-images/theme-two.png')); ?>">
                        </div>

                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <h6 class="text-center"><?php echo e(__(ThemeList::UNIVERSITY->value)); ?></h6>
                        <div class="screen">
                            <img src="<?php echo e(asset('uploads/website-images/theme-three.webp')); ?>">
                        </div>

                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <h6 class="text-center"><?php echo e(__(ThemeList::BUSINESS->value)); ?></h6>
                        <div class="screen">
                            <img src="<?php echo e(asset('uploads/website-images/theme-four.webp')); ?>">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <h6 class="text-center"><?php echo e(__(ThemeList::YOGA->value)); ?></h6>
                        <div class="screen">
                            <img src="<?php echo e(asset('uploads/website-images/theme-five.webp')); ?>">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <h6 class="text-center"><?php echo e(__(ThemeList::KITCHEN->value)); ?></h6>
                        <div class="screen">
                            <img src="<?php echo e(asset('uploads/website-images/theme-six.webp')); ?>">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <h6 class="text-center"><?php echo e(__(ThemeList::LANGUAGE->value)); ?></h6>
                        <div class="screen">
                            <img src="<?php echo e(asset('uploads/website-images/theme-seven.webp')); ?>">
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-4 col-xl-3">
                        <h6 class="text-center"><?php echo e(__(ThemeList::KINDERGARTEN->value)); ?></h6>
                        <div class="screen">
                            <img src="<?php echo e(asset('uploads/website-images/theme-eight.webp')); ?>">
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/js/colorpicker.js')); ?>"></script>
    <script>
        $(".colorpickerinput").colorpicker({
            format: 'hex',
            component: '.input-group-append',
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\SiteAppearance\resources\views\index.blade.php ENDPATH**/ ?>