<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Instructor Request')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Instructor Request')); ?></h1>
            </div>

            <div class="section-body">
                <div class="row mt-4">
                    
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.instructor-request.index')); ?>" method="GET"
                                    onchange="$(this).trigger('submit')" class="form_padding">
                                    <div class="row">
                                        <div class="col-md-3 form-group">
                                            <input type="text" name="keyword" value="<?php echo e(request()->get('keyword')); ?>"
                                                class="form-control" placeholder="<?php echo e(__('Search')); ?>">
                                        </div>


                                        <div class="col-md-3 form-group">
                                            <select name="status" id="status" class="form-control">
                                                <option value=""><?php echo e(__('Select Status')); ?></option>
                                                <option value="pending"
                                                    <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Pending')); ?>

                                                </option>
                                                <option value="approved"
                                                    <?php echo e(request('status') == 'approved' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Approved')); ?>

                                                </option>
                                                <option value="rejected"
                                                    <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Rejected')); ?>

                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <select name="order_by" id="order_by" class="form-control">
                                                <option value=""><?php echo e(__('Order By')); ?></option>
                                                <option value="1" <?php echo e(request('order_by') == '1' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('ASC')); ?>

                                                </option>
                                                <option value="0" <?php echo e(request('order_by') == '0' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('DESC')); ?>

                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-3 form-group">
                                            <select name="par-page" id="par-page" class="form-control">
                                                <option value=""><?php echo e(__('Per Page')); ?></option>
                                                <option value="10" <?php echo e('10' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('10')); ?>

                                                </option>
                                                <option value="50" <?php echo e('50' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('50')); ?>

                                                </option>
                                                <option value="100"
                                                    <?php echo e('100' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('100')); ?>

                                                </option>
                                                <option value="all"
                                                    <?php echo e('all' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('All')); ?>

                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <div class="table-responsive table-invoice">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('SN')); ?></th>
                                                <th><?php echo e(__('Name')); ?></th>
                                                <th><?php echo e(__('Email')); ?></th>
                                                <th><?php echo e(__('Status')); ?></th>
                                                <th><?php echo e(__('Action')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $instructorRequests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $request): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e(++$index); ?></td>
                                                    <td><?php echo e($request->user->name); ?></td>
                                                    <td><?php echo e($request->user->email); ?></td>

                                                    <td>
                                                        <?php if($request->status == 'pending'): ?>
                                                            <span class="badge badge-warning"><?php echo e(__('Pending')); ?></span>
                                                        <?php elseif($request->status == 'approved'): ?>
                                                            <span class="badge badge-success"><?php echo e(__('Approved')); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge badge-danger"><?php echo e(__('Rejected')); ?></span>
                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <a href="<?php echo e(route('admin.instructor-request.edit', $request->id)); ?>"
                                                            class="btn btn-primary btn-sm"><i class="fa fa-eye"
                                                                aria-hidden="true"></i></a>
                                                        <?php if($request->status != 'approved'): ?>
                                                        <a href="javascript:;" data-toggle="modal"
                                                            data-target="#deleteModal" class="btn btn-danger btn-sm"
                                                            onclick="deleteData(<?php echo e($request->id); ?>)"><i
                                                                class="fa fa-trash" aria-hidden="true"></i></a>
                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __('Instructor Request'),'route' => '','create' => 'no','message' => __('No data found!'),'colspan' => '5'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        </section>
    </div>

    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
    <script>
        "use strict";

        function deleteData(id) {
            $("#deleteForm").attr("action", "<?php echo e(url('admin/instructor-request')); ?>" + "/" + id)
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\InstructorRequest\resources\views\instructor-request\index.blade.php ENDPATH**/ ?>