<?php
    $footerSetting = \Modules\FooterSetting\app\Models\FooterSetting::first();
    $footer_menu_one = menu_get_by_slug('footer-col-one');
    $footer_menu_two = menu_get_by_slug('footer-col-two-1PiTN');
    $footer_menu_three = menu_get_by_slug('footer-col-three');
?>

<footer
    class="footer__area <?php echo e(Cache::get('setting')?->site_theme && Route::is('home') == 'theme-two' ? 'footer__area-two' : ''); ?>">

    <div class="footer__top">
        <div class="container">
            <div class="row">
                <div class="col-xl-3 col-lg-4 col-md-6">
                    <div class="footer__widget">
                        <div class="logo mb-35">
                            <a href="<?php echo e(route('home')); ?>"><img src="<?php echo e(!empty($footerSetting?->logo) ? asset($footerSetting?->logo) : asset($setting?->logo)); ?>" alt="img"></a>
                        </div>
                        <div class="footer__content">
                            <p><?php echo e($footerSetting?->footer_text); ?></p>
                            <ul class="list-wrap">
                                <li><?php echo e($footerSetting?->address); ?></li>
                                <li><?php echo e($footerSetting?->phone); ?></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                    <?php if(count($footer_menu_one->menuItems) > 0): ?>
                    <div class="footer__widget">
                        <h4 class="footer__widget-title"><?php echo e(__('Useful Links')); ?></h4>
                        <div class="footer__link">
                            <ul class="list-wrap">
                                <?php $__currentLoopData = $footer_menu_one->menuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footerMenuOne): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(url($footerMenuOne?->link)); ?>"><?php echo e($footerMenuOne?->label); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                    <?php if(count($footer_menu_two->menuItems) > 0): ?>
                    <div class="footer__widget">
                        <h4 class="footer__widget-title"><?php echo e(__('Our Company')); ?></h4>
                        <div class="footer__link">
                            <ul class="list-wrap">
                                <?php $__currentLoopData = $footer_menu_two->menuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footerMenuTwo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><a href="<?php echo e(url($footerMenuTwo?->link)); ?>"><?php echo e($footerMenuTwo?->label); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-xl-3 col-lg-4 col-md-6">
                    <div class="footer__widget">
                        <h4 class="footer__widget-title"><?php echo e(__('Get In Touch')); ?></h4>
                        <div class="footer__contact-content">
                            <p><?php echo e($footerSetting?->get_in_touch_text); ?></p>
                            <ul class="list-wrap footer__social">
                                <?php $__currentLoopData = getSocialLinks(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socialLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e($socialLink->link); ?>" target="_blank">
                                            <img src="<?php echo e(asset($socialLink->icon)); ?>" alt="img">
                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div class="app-download">
                            <?php if($footerSetting?->google_play_link): ?>
                                <a href="<?php echo e($footerSetting->google_play_link); ?>"><img
                                        src="<?php echo e(asset('frontend/img/others/google-play.svg')); ?>" alt="img"></a>
                            <?php endif; ?>
                            <?php if($footerSetting?->apple_store_link): ?>
                                <a href="<?php echo e($footerSetting->apple_store_link); ?>"><img
                                        src="<?php echo e(asset('frontend/img/others/apple-store.svg')); ?>" alt="img"></a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="footer__bottom">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-7">
                    <div class="copy-right-text">
                        <?php if(Cache::get('setting')->copyright_text): ?>
                        <p>© <?php echo e(Cache::get('setting')->copyright_text); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-5">
                    <div class="footer__bottom-menu">
                        <ul class="list-wrap">
                            <?php $__currentLoopData = $footer_menu_three->menuItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $footerMenuThree): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(url($footerMenuThree?->link)); ?>"><?php echo e($footerMenuThree?->label); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views/frontend/layouts/footer.blade.php ENDPATH**/ ?>