<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap mt-3">
        <div class="dashboard__content-title d-flex flex-wrap justify-content-between">
            <h4 class="title"><?php echo e(__('Announcements')); ?></h4>
            <a href="<?php echo e(route('instructor.announcements.create')); ?>" class="btn btn-primary btn-hight-basic">
                <?php echo e(__('Create Announcement')); ?>

            </a>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table table-responsive">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th><?php echo e(__('No')); ?></th>
                                <th><?php echo e(__('Course')); ?></th>
                                <th><?php echo e(__('Title')); ?></th>

                                <th><?php echo e(__('Date')); ?></th>

                                <th><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $announcements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $announcement): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <p><?php echo e($loop->iteration); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e(truncate($announcement->course->title)); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e(truncate($announcement->title)); ?></p>
                                    </td>
                                    <td>
                                        <p><?php echo e(formatDate($announcement->created_at)); ?></p>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('instructor.announcements.edit', $announcement->id)); ?>"
                                            class="text-primary"><i class="far fa-edit"></i></a>
                                        <a href="<?php echo e(route('instructor.announcements.destroy', $announcement->id)); ?>"
                                            class="text-danger delete-item"><i class="fas fa-trash-alt"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td class="text-center" colspan="100"><?php echo e(__('No Data')); ?></td>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.instructor-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\announcement\index.blade.php ENDPATH**/ ?>