<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Create Page')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Create Page')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.page-builder.index')); ?>"><?php echo e(__('Page Builder')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Create Page')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Create Page')); ?></h4>
                                <div>
                                    <a href="<?php echo e(route('admin.page-builder.index')); ?>" class="btn btn-primary"><i
                                            class="fa fa-arrow-left"></i> <?php echo e(__('Back')); ?></a>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.page-builder.store')); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="name"><?php echo e(__('name')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input type="text" id="name" name="name"
                                                    value="<?php echo e(old('name')); ?>" placeholder=""
                                                    class="form-control">
                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="question"><?php echo e(__('Slug')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input type="text" id="slug" name="slug"
                                                    value="<?php echo e(old('slug')); ?>" placeholder=""
                                                    class="form-control">
                                                <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="answer"><?php echo e(__('Content')); ?><span
                                                        class="text-danger">*</span></label>
                                                <textarea type="text" id="content" name="content" placeholder="" cols="30" rows="30"
                                                    class="form-control summernote"><?php echo e(old('content')); ?></textarea>
                                                <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="status"><?php echo e(__('Status')); ?><span
                                                        class="text-danger">*</span></label>
                                                <select name="status" id="" class="form-control">
                                                    <option value="1"><?php echo e(__('Active')); ?></option>
                                                    <option value="0"><?php echo e(__('Inactive')); ?></option>
                                                </select>
                                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="">
                                            <?php if (isset($component)) { $__componentOriginal42eb0eb0445477e4b420137b90787aa6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42eb0eb0445477e4b420137b90787aa6 = $attributes; } ?>
<?php $component = App\View\Components\Admin\SaveButton::resolve(['text' => __('Save')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.save-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\SaveButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $attributes = $__attributesOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $component = $__componentOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__componentOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).ready(function() {
                $("#name").on("keyup", function(e) {
                    $("#slug").val(convertToSlug($(this).val()));
                })
            });
        })(jQuery);

        function convertToSlug(Text) {
            return Text
                .toLowerCase()
                .replace(/[^\w ]+/g, '')
                .replace(/ +/g, '-');
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\PageBuilder\resources\views\create.blade.php ENDPATH**/ ?>