<div class="tab-pane fade" id="instamojo_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.instamojo-update')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="row">

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Gateway charge (%)')); ?></label>
                <input type="text" class="form-control" name="instamojo_charge"
                    value="<?php echo e($payment_setting->instamojo_charge); ?>">
            </div>
            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Account Mode')); ?></label>
                <select name="instamojo_account_mode" id="instamojo_account_mode" class="form-control">
                    <option <?php echo e($payment_setting->instamojo_account_mode == 'Sandbox' ? 'selected' : ''); ?>

                        value="Sandbox"><?php echo e(__('Sandbox')); ?></option>
                    <option <?php echo e($payment_setting->instamojo_account_mode == 'Live' ? 'selected' : ''); ?> value="Live">
                        <?php echo e(__('Live')); ?></option>
                </select>
            </div>

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('API key')); ?></label>
                <?php if(env('APP_MODE') == 'DEMO'): ?>
                    <input type="text" class="form-control" name="instamojo_api_key"
                        value="instamojo-test-348949439-api-key">
                <?php else: ?>
                    <input type="text" class="form-control" name="instamojo_api_key"
                        value="<?php echo e($payment_setting->instamojo_api_key); ?>">
                <?php endif; ?>
            </div>

            <div class="form-group col-md-6">
                <label for=""><?php echo e(__('Auth token')); ?></label>
                <?php if(env('APP_MODE') == 'DEMO'): ?>
                    <input type="text" class="form-control" name="instamojo_auth_token"
                        value="instamojo-auth-348949439-token">
                <?php else: ?>
                    <input type="text" class="form-control" name="instamojo_auth_token"
                        value="<?php echo e($payment_setting->instamojo_auth_token); ?>">
                <?php endif; ?>
            </div>

        </div>

        <div class="form-group">
            <label><?php echo e(__('New Image')); ?> <code>(<?php echo e(__('Recommended')); ?>: 210X100 PX)</code></label>
            <div id="image-preview-instamojo" class="image-preview">
                <label for="image-upload-instamojo"
                    id="image-label-instamojo"><?php echo e(__('Image')); ?></label>
                <input type="file" name="instamojo_image" id="image-upload-instamojo">
            </div>

        </div>
        <div class="form-group">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="instamojo_status" class="custom-switch-input">
                <input type="checkbox" value="active" name="instamojo_status" class="custom-switch-input"
                    <?php echo e($payment_setting?->instamojo_status == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
            </label>
        </div>

        <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\sections\instamojo.blade.php ENDPATH**/ ?>