<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Edit Testimonial')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Testimonials')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a
                            href="<?php echo e(route('admin.testimonial.index')); ?>"><?php echo e(__('Testimonials')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Edit Testimonial')); ?></div>
                </div>
            </div>
            <div class="section-body row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="service_card"><?php echo e(__('Available Translations')); ?></h5>
                            <?php if(auth()->guard('admin')->user()->can('testimonial.translate')): ?>
                                <hr>
                                <?php if($code !== $languages->first()->code): ?>
                                    <button onclick="translateAll()" class="btn btn-primary"
                                        id="translate-btn"><?php echo e(__('Translate')); ?></button>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <div class="lang_list_top">
                                <ul class="lang_list">
                                    <?php $__currentLoopData = allLanguages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a id="<?php echo e(request('code') == $language->code ? 'selected-language' : ''); ?>"
                                                href="<?php echo e(route('admin.testimonial.edit', ['testimonial' => $testimonial->id, 'code' => $language->code])); ?>">
                                                <i
                                                    class="fas <?php echo e(request('code') == $language->code ? 'fa-eye' : 'fa-edit'); ?>"></i>
                                                <?php echo e($language->name); ?>

                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div class="mt-2 alert alert-danger" role="alert">
                                <?php
                                    $current_language = $languages->where('code', request()->get('code'))->first();
                                ?>
                                <p><?php echo e(__('Your editing mode')); ?> :
                                    <b><?php echo e($current_language?->name); ?></b>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Edit Testimonial')); ?></h4>
                                <div>
                                    <a href="<?php echo e(route('admin.testimonial.index')); ?>" class="btn btn-primary"><i
                                            class="fa fa-arrow-left"></i> <?php echo e(__('Back')); ?></a>
                                </div>
                            </div>
                            <div class="card-body">
                                <form
                                    action="<?php echo e(route('admin.testimonial.update', [
                                        'testimonial' => $testimonial->id,
                                        'code' => $code,
                                    ])); ?>"
                                    enctype="multipart/form-data" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="offset-md-2 col-md-8">
                                            <div class="form-group">
                                                <label for="name"><?php echo e(__('Name')); ?> <span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" class="form-control"
                                                    name="name" id="name" placeholder="<?php echo e(__('Enter Name')); ?>"
                                                    value="<?php echo e(old('name', $testimonial->getTranslation($code)->name)); ?>">
                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="offset-md-2 col-md-8">
                                            <div class="form-group">
                                                <label for="designation"><?php echo e(__('Designation')); ?> <span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" class="form-control"
                                                    name="designation" id="designation"
                                                    placeholder="<?php echo e(__('Enter designation')); ?>"
                                                    value="<?php echo e(old('designation', $testimonial->getTranslation($code)->designation)); ?>">
                                                <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="offset-md-2 col-md-8">
                                            <div class="form-group">
                                                <label for="comment"><?php echo e(__('Comment')); ?> <span
                                                        class="text-danger">*</span></label>
                                                <textarea data-translate="true" name="comment" id="comment" cols="30" rows="10"
                                                    class="form-control text-area-5" placeholder="<?php echo e(__('Enter comment')); ?>"><?php echo e(old('comment', $testimonial->getTranslation($code)->comment)); ?></textarea>
                                                <?php $__errorArgs = ['comment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <?php if($code == $languages->first()->code): ?>
                                            <div class="offset-md-2 col-md-8">
                                                <div class="form-group">
                                                    <label for="rating"><?php echo e(__('Rating')); ?></label>
                                                    <input type="number" min="0" max="5" step=".1"
                                                        class="form-control" name="rating" id="rating"
                                                        placeholder="<?php echo e(__('Enter rating 0-5')); ?>"
                                                        value="<?php echo e(old('rating', $testimonial->rating)); ?>">
                                                    <?php $__errorArgs = ['rating'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="offset-md-2 col-md-8">
                                                <div class="form-group">
                                                    <label><?php echo e(__('Image')); ?> <code>(<?php echo e(__('Recommended')); ?>: 510X410 PX)</code></label>
                                                    <div id="image-preview" class="image-preview"
                                                        <?php if($testimonial->image): ?> style="background-image: url(<?php echo e(asset($testimonial->image)); ?>); background-size: cover; background-position: center center;" <?php endif; ?>>
                                                        <label for="image-upload"
                                                            id="image-label"><?php echo e(__('Image')); ?></label>
                                                        <input type="file" name="image" id="image-upload">
                                                    </div>
                                                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="text-center offset-md-2 col-md-8">
                                            <?php if (isset($component)) { $__componentOriginalf3ad9c349c70d58844f8581b0990debd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3ad9c349c70d58844f8581b0990debd = $attributes; } ?>
<?php $component = App\View\Components\Admin\UpdateButton::resolve(['text' => __('Update')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.update-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\UpdateButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $attributes = $__attributesOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $component = $__componentOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__componentOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/js/jquery.uploadPreview.min.js')); ?>"></script>
    <script>
        "use strict";
        $.uploadPreview({
            input_field: "#image-upload",
            preview_box: "#image-preview",
            label_field: "#image-label",
            label_default: "<?php echo e(__('Choose Image')); ?>",
            label_selected: "<?php echo e(__('Change Image')); ?>",
            no_label: false,
            success_callback: null
        });
    </script>
    <script>
        "use strict";
        var isTranslatingInputs = true;

        function translateOneByOne(inputs, index = 0) {
            if (index >= inputs.length) {
                if (isTranslatingInputs) {
                    isTranslatingInputs = false;
                    translateAllTextarea();
                }
                $('#translate-btn').prop('disabled', false);
                $('#update-btn').prop('disabled', false);
                return;
            }

            var $input = $(inputs[index]);
            var inputValue = $input.val();

            if (inputValue) {
                $.ajax({
                    url: "<?php echo e(route('admin.languages.update.single')); ?>",
                    type: "POST",
                    data: {
                        lang: '<?php echo e($code); ?>',
                        text: inputValue,
                        _token: '<?php echo e(csrf_token()); ?>'
                    },
                    dataType: 'json',
                    beforeSend: function() {
                        $input.prop('disabled', true);
                        iziToast.show({
                            timeout: false,
                            close: true,
                            theme: 'dark',
                            icon: 'loader',
                            iconUrl: 'https://hub.izmirnic.com/Files/Images/loading.gif',
                            title: "<?php echo e(__('Translation Processing, please wait...')); ?>",
                            position: 'center',
                        });
                    },
                    success: function(response) {
                        $input.val(response);
                        $input.prop('disabled', false);
                        iziToast.destroy();
                        toastr.success("<?php echo e(__('Translated Successfully!')); ?>");
                        translateOneByOne(inputs, index + 1);
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        console.error(textStatus, errorThrown);
                        iziToast.destroy();
                        toastr.error('Error', 'Error');
                    }
                });
            } else {
                translateOneByOne(inputs, index + 1);
            }
        }

        function translateAll() {
            iziToast.question({
                timeout: 20000,
                close: false,
                overlay: true,
                displayMode: 'once',
                id: 'question',
                zindex: 999,
                title: "<?php echo e(__('This will take a while!')); ?>",
                message: "<?php echo e(__('Are you sure?')); ?>",
                position: 'center',
                buttons: [
                    ["<button><b><?php echo e(__('Yes')); ?></b></button>", function(instance, toast) {
                        var isDemo = "<?php echo e(env('PROJECT_MODE') ?? 1); ?>";

                        if (isDemo == 0) {
                            instance.hide({
                                transitionOut: 'fadeOut'
                            }, toast, 'button');
                            toastr.error("<?php echo e(__('This Is Demo Version. You Can Not Change Anything')); ?>");
                            return;
                        }

                        $('#translate-btn').prop('disabled', true);
                        $('#update-btn').prop('disabled', true);

                        instance.hide({
                            transitionOut: 'fadeOut'
                        }, toast, 'button');

                        var inputs = $('input[data-translate="true"]').toArray();
                        translateOneByOne(inputs);

                    }, true],
                    ["<button><?php echo e(__('No')); ?></button>", function(instance, toast) {

                        instance.hide({
                            transitionOut: 'fadeOut'
                        }, toast, 'button');

                    }],
                ],
                onClosing: function(instance, toast, closedBy) {},
                onClosed: function(instance, toast, closedBy) {}
            });
        };

        function translateAllTextarea() {
            var inputs = $('textarea[data-translate="true"]').toArray();
            if (inputs.length === 0) {
                return;
            }
            translateOneByOne(inputs);
        }

        $(document).ready(function() {
            var selectedTranslation = $('#selected-language').text();
            var btnText = "<?php echo e(__('Translate to')); ?>" + selectedTranslation;
            $('#translate-btn').text(btnText);
        });
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Testimonial\resources\views\edit.blade.php ENDPATH**/ ?>