<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap">

        <div class="dashboard__content-title d-flex justify-content-between">
            <h4 class="title"><?php echo e(__('Create Course')); ?></h4>
        </div>
        <div class="row">
            <div class="col-12">
                <?php echo $__env->make('frontend.instructor-dashboard.course.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="instructor__profile-form-wrap">
                    <form action="<?php echo e(route('instructor.courses.update')); ?>" class="instructor__profile-form course-form">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="course_id" id="" value="<?php echo e($courseId); ?>">
                        <input type="hidden" name="step" id="" value="2">
                        <input type="hidden" name="next_step" value="3">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-grp">
                                    <label for="capacity"><?php echo e(__('Capacity')); ?> <code></code></label>
                                    <input id="capacity" name="capacity" type="text" value="<?php echo e($course?->capacity); ?>">
                                    <code><?php echo e(__('leave blank for unlimited')); ?></code>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-grp">
                                    <label for="course_duration"><?php echo e(__('Course Duration (Minutes)')); ?>

                                        <code>*</code></label>
                                    <input id="course_duration" name="course_duration" type="text"
                                        value="<?php echo e($course?->duration); ?>">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <p><?php echo e(__('Q&A')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <div class="switcher ms-3">
                                        <label for="toggle-0">
                                            <input type="checkbox" <?php if($course?->qna == 1): echo 'checked'; endif; ?> id="toggle-0"
                                                value="1" name="qna" />
                                            <span><small></small></span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <p><?php echo e(__('Completion Certificate')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <div class="switcher ms-3">
                                        <label for="toggle-1">
                                            <input type="checkbox" <?php if($course?->certificate == 1): echo 'checked'; endif; ?> id="toggle-1"
                                                value="1" name="certificate" />
                                            <span><small></small></span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="row d-none">
                                <div class="col-md-6 ">
                                    <p><?php echo e(__('Downloadable')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <div class="switcher ms-3">
                                        <label for="toggle-2">
                                            <input type="checkbox" <?php if($course?->downloadable == 1): echo 'checked'; endif; ?> id="toggle-2"
                                                value="1" name="downloadable" />
                                            <span><small></small></span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <p><?php echo e(__('Patner instructor')); ?></p>
                                </div>
                                <div class="col-md-6">
                                    <div class="switcher ms-3">
                                        <label for="toggle-3">
                                            <input class="partner_instructor_btn" <?php if($course?->partner_instructor == 1): echo 'checked'; endif; ?>
                                                value="1" type="checkbox" id="toggle-3" name="partner_instructor" />
                                            <span><small></small></span>
                                        </label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div
                                    class="partner_instructor_list <?php echo e($course?->partner_instructor == 0 ? 'd-none' : ''); ?>">
                                    <label for="cpacity"><?php echo e(__('Select a partner instructor')); ?> <code></code></label>
                                    <select class="select2 partner_instructor_select form-select" name="partner_instructors[]"
                                        multiple="multiple">
                                        <?php $__currentLoopData = $course?->partnerInstructors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($instructor->instructor->id); ?>" selected="selected">
                                                <?php echo e($instructor?->instructor->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-12 mt-2">
                                <div class="from-group">
                                    <label for="category"><?php echo e(__('Category')); ?><span class="text-danger">*</span></label>
                                    <select class="select2 form-select category" name="category">
                                        <option value=""><?php echo e(__('Select')); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($category->subCategories->isNotEmpty()): ?>
                                                <optgroup label="<?php echo e($category->translation?->name); ?>">
                                                    <?php $__currentLoopData = $category->subCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subCategory): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php if($course?->category_id == $subCategory->id): echo 'selected'; endif; ?> value="<?php echo e($subCategory->id); ?>">
                                                            <?php echo e($subCategory->translation?->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </optgroup>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <?php $__errorArgs = ['category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            

                            <div class="filter-holder">
                                <div class="row mb-3">
                                    <div class="col-md-4 mb-3">
                                        <div class="card">
                                            <div class="card-body">
                                                <h5 class="card-title"><?php echo e(__('Level')); ?></h5>
                                                <?php
                                                    $courseLevel = $course->levels->pluck('level_id')->toArray();
                                                    $courseLanguage = $course->languages
                                                        ->pluck('language_id')
                                                        ->toArray();
                                                    $courseFilterOption = $course->filtersOptions
                                                        ->pluck('filter_option_id')
                                                        ->toArray();
                                                ?>
                                                <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="form-group">
                                                        <div class="form-check">
                                                            <input class="form-check-input"
                                                                <?php echo e(in_array($level->id, $courseLevel) ? 'checked' : ''); ?>

                                                                name="levels[]" type="checkbox"
                                                                value="<?php echo e($level->id); ?>"
                                                                id="language-<?php echo e($level->id); ?>">
                                                            <label class="form-check-label"
                                                                for="language-<?php echo e($level->id); ?>">
                                                                <?php echo e($level->translation?->name); ?>

                                                            </label>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="card">
                                            <div class="card-body">
                                                <h5 class="card-title"><?php echo e(__('Language')); ?></h5>
                                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="form-group">
                                                        <div class="form-check">
                                                            <input class="form-check-input"
                                                                <?php echo e(in_array($language->id, $courseLanguage) ? 'checked' : ''); ?>

                                                                name="languages[]" type="checkbox"
                                                                value="<?php echo e($language->id); ?>"
                                                                id="checkbox<?php echo e($language->id); ?>">
                                                            <label class="form-check-label"
                                                                for="checkbox<?php echo e($language->id); ?>">
                                                                <?php echo e($language->name); ?>

                                                            </label>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                            </div>

                            <div>
                                <button class="btn btn-primary" type="submit"><?php echo e(__('Save')); ?></button>
                            </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('frontend/js/default/courses.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.instructor-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\course\more-information.blade.php ENDPATH**/ ?>