<?php
    $bkashCredentials = (object) Modules\BkashPG\app\Models\BkashPGModel::pluck('value', 'key')->toArray();
?>
<div class="tab-pane fade" id="bkash_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.bkash.update', 1)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="row">
            <div class="form-group col-md-6">
                <label for="bkash_charge"><?php echo e(__('Gateway charge (%)')); ?> <span class="text-danger">*</span></label>
                <input step="0.01" type="number" class="form-control" name="bkash_charge" id="bkash_charge"
                    value="<?php echo e(@$bkashCredentials?->bkash_charge); ?>" required="true"
                    placeholder="<?php echo e(__('Gateway charge (%)')); ?>">
            </div>
            <div class="form-group col-md-6">
                <label><?php echo e(__('Sandbox Status')); ?> <span class="text-danger">*</span></label>
                <select name="bkash_sandbox" class="form-control select2" id="bkash_sandbox">
                    <option value=""><?php echo e(__('Select Sandbox Status')); ?></option>
                    <option value="<?php echo e(config('basicpayment.default_status.active_int')); ?>" <?php if(config('basicpayment.default_status.active_int') == old('bkash_sandbox', @$bkashCredentials?->bkash_sandbox)): echo 'selected'; endif; ?>>
                        <?php echo e(__('Sandbox')); ?></option>
                    <option value="<?php echo e(config('basicpayment.default_status.inactive_int')); ?>"
                        <?php if(config('basicpayment.default_status.inactive_int') == old('bkash_sandbox', @$bkashCredentials?->bkash_sandbox)): echo 'selected'; endif; ?>><?php echo e(__('Live')); ?></option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="bkash_key"><?php echo e(__('Bkash Key')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="bkash_key" id="bkash_key"
                    value="<?php echo e(@$bkashCredentials?->bkash_key); ?>" required="true" placeholder="<?php echo e(__('Bkash Key')); ?>">
            </div>
            <div class="form-group col-md-6">
                <label for="bkash_secret"><?php echo e(__('Bkash Secret')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="bkash_secret" id="bkash_secret"
                    value="<?php echo e(@$bkashCredentials?->bkash_secret); ?>" required="true"
                    placeholder="<?php echo e(__('Bkash Secret')); ?>">
            </div>
            <div class="form-group col-md-6">
                <label for="bkash_username"><?php echo e(__('Bkash Username')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="bkash_username" id="bkash_username"
                    value="<?php echo e(@$bkashCredentials?->bkash_username); ?>" required="true"
                    placeholder="<?php echo e(__('Bkash Username')); ?>">
            </div>
            <div class="form-group col-md-6">
                <label for="bkash_password"><?php echo e(__('Bkash Password')); ?> <span class="text-danger">*</span></label>
                <input type="text" class="form-control" name="bkash_password" id="bkash_password"
                    value="<?php echo e(@$bkashCredentials?->bkash_password); ?>" required="true"
                    placeholder="<?php echo e(__('Bkash Password')); ?>">
            </div>

            <div class="form-group col-md-12">
                <label><?php echo e(__('New Image')); ?></label>
                <div id="image-preview-bkash" class="image-preview"
                    style="background-image: url(<?php echo e(asset(@$bkashCredentials?->bkash_image ?? 'uploads/website-images/bkash.png')); ?>);">
                    <label for="image-upload-bkash" id="image-label-bkash"><?php echo e(__('Image')); ?></label>
                    <input type="file" name="bkash_image" id="image-upload-bkash">
                </div>

            </div>

            <div class="form-group col-md-12">
                <label class="d-flex align-items-center">
                    <input type="hidden" value="<?php echo e(config('basicpayment.default_status.inactive_text')); ?>"
                        name="bkash_status" class="custom-switch-input">
                    <input type="checkbox" <?php if(config('basicpayment.default_status.active_text') == old('bkash_status', @$bkashCredentials?->bkash_status)): echo 'checked'; endif; ?>
                        value="<?php echo e(config('basicpayment.default_status.active_text')); ?>" name="bkash_status"
                        class="custom-switch-input"
                        <?php echo e(@$bkashCredentials?->bkash_status == 'active' ? 'checked' : ''); ?>>
                    <span class="custom-switch-indicator"></span>
                    <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
                </label>
            </div>

        </div>
        <div class="row">
            <div class="col-md-12">
                <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
            </div>
        </div>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\sections\bkash.blade.php ENDPATH**/ ?>