<div class="tab-pane fade" id="wasabi_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.update-wasabi-cloud')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="form-group">
            <label for=""><?php echo e(__('Access ID')); ?></label>
            <?php if(env('APP_MODE') == 'DEMO'): ?>
                <input type="text" class="form-control" name="wasabi_access_id" value="access_key_id">
            <?php else: ?>
                <input type="text" class="form-control" name="wasabi_access_id"
                    value="<?php echo e($setting->wasabi_access_id); ?>">
            <?php endif; ?>
        </div>
        <div class="form-group">
            <label for=""><?php echo e(__('Secret key')); ?></label>
            <?php if(env('APP_MODE') == 'DEMO'): ?>
                <input type="text" class="form-control" name="wasabi_secret_key" value="secret_key">
            <?php else: ?>
                <input type="text" class="form-control" name="wasabi_secret_key"
                    value="<?php echo e($setting->wasabi_secret_key); ?>">
            <?php endif; ?>
        </div>
        <div class="form-group">
            <label for=""><?php echo e(__('Bucket Name')); ?></label>
            <?php if(env('APP_MODE') == 'DEMO'): ?>
                <input type="text" class="form-control" name="wasabi_bucket" value="bucket_name">
            <?php else: ?>
                <input type="text" class="form-control" name="wasabi_bucket"
                    value="<?php echo e($setting->wasabi_bucket); ?>">
            <?php endif; ?>
        </div>
        <div class="form-group">
            <label for=""><?php echo e(__('Region')); ?></label>
            <select name="wasabi_region"  class="form-control">
                <?php $__currentLoopData = config('cloud-storage-region.region'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option <?php echo e($setting?->wasabi_region == $key ? 'selected' : ''); ?> value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
        <div class="form-group">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="wasabi_status" class="custom-switch-input">
                <input type="checkbox" value="active" name="wasabi_status" class="custom-switch-input"
                    <?php echo e($setting?->wasabi_status == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
            </label>
        </div>

        <button class="btn btn-primary"><?php echo e(__('Update')); ?></button>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\GlobalSetting\resources\views\credientials\sections\wasabi.blade.php ENDPATH**/ ?>