<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('Order History')); ?></h4>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table">
                    <div class="invoice">
                        <div class="invoice-print">
                            <div class="row">
                                <div class="col-lg-12 info-wrapper">
                                    <div class="row w-100">
                                        <div class="col-12 col-sm-6 col-md-4">
                                            <div class="invoice-title">
                                                <h2><?php echo e(__('Invoice')); ?></h2>
                                                <div class="invoice-number"><?php echo e(__('Order ')); ?> #<?php echo e($order->invoice_id); ?>

                                                </div>
                                                <span
                                                    class="d-block"><strong><?php echo e(__('Order Date')); ?>:</strong><?php echo e(formatDate($order->created_at)); ?></span>
                                                <?php if($order->isBundleOrder()): ?>
                                                    <span class="d-block"><strong><?php echo e(__('Bundle Name')); ?>:</strong>
                                                        <?php echo e($order?->order_details?->title); ?></span>
                                                <?php endif; ?>
                                                <?php if($order->isGiftOrder()): ?>
                                                    <address>
                                                        <strong><?php echo e(__('Gift')); ?>:</strong>
                                                        <?php if(empty($order?->order_details?->verification_token)): ?>
                                                            <div class="badge bg-success"><?php echo e(__('Claimed')); ?></div>
                                                        <?php else: ?>
                                                        <div class="badge bg-warning"><?php echo e(__('Pending')); ?></div>
                                                        <?php endif; ?>
                                                        <br>
                                                        <?php echo e(__('Recipient Name')); ?>:
                                                        <?php echo e($order?->order_details?->recipient_name); ?><br>
                                                        <?php echo e(__('Recipient Email')); ?>:
                                                        <?php echo e($order?->order_details?->recipient_email); ?><br>
                                                    </address>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-12 col-sm-6 col-md-4">
                                            <address>
                                                <strong><?php echo e(__('Billed To')); ?>:</strong><br>
                                                <?php echo e($order->user->name); ?><br>
                                                <?php echo e(__('Phone:')); ?> <?php echo e($order->user->phone); ?><br>
                                                <?php echo e(__('Email')); ?> <?php echo e($order->user->email); ?><br>
                                                <?php echo e(__('Address')); ?> <?php echo e($order->user->address); ?><br>
                                            </address>
                                        </div>
                                        <div class="col-12 col-sm-6 col-md-4">
                                            <address>
                                                <strong><?php echo e(__('Payment Method')); ?>:</strong><br>
                                                <?php echo e($order->payment_method); ?><br>
                                            </address>
                                            <address>
                                                <strong><?php echo e(__('Payment Status')); ?>:</strong><br>
                                                <?php echo e($order->payment_status); ?><br><br>
                                            </address>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-4">
                                <div class="col-md-12">
                                    <div class="section-title"><?php echo e(__('Order Summary')); ?></div>
                                    <div class="table-responsive">
                                        <table class="table table-striped table-hover table-md">
                                            <tr>
                                                <th data-width="40">#</th>
                                                <th><?php echo e(__('Item')); ?></th>
                                                <th><?php echo e(__('by')); ?></th>
                                                <th class="text-center"><?php echo e(__('Price')); ?></th>
                                            </tr>
                                            <?php $__currentLoopData = $order->orderItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($loop->iteration); ?></td>
                                                    <td><?php echo e($item->course->title); ?></td>
                                                    <td>
                                                        <?php echo e($item->course->instructor->name); ?>

                                                        <br>
                                                        <?php echo e($item->course->instructor->email); ?>

                                                    </td>
                                                    <td class="text-center">
                                                        <?php if($order->isBundleOrder()): ?>
                                                            --
                                                        <?php else: ?>
                                                            <?php echo e($item->price * $order->conversion_rate); ?>

                                                            <?php echo e($order->payable_currency); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </table>
                                    </div>
                                    <div class="row mt-4">
                                        <div class="col-lg-4"></div>
                                        <div class="col-lg-8 text-end">
                                            <?php if($order->isBundleOrder()): ?>
                                                <?php
                                                    $subTotal = $order->payable_amount;
                                                    $subTotalWithCharge = $subTotal * $order->conversion_rate;
                                                    $gatewayCharge = 0;
                                                    if ($order->gateway_charge > 0) {
                                                        $gatewayCharge =
                                                            ($order->gateway_charge / $subTotalWithCharge) * 100;
                                                    }
                                                    $total = number_format(
                                                        $subTotalWithCharge + $order->gateway_charge,
                                                        2,
                                                    );
                                                ?>
                                                <div class="invoice-detail-item">
                                                    <div class="invoice-detail-name"><?php echo e(__('Subtotal')); ?></div>
                                                    <div class="invoice-detail-value">
                                                        <?php echo e(number_format($subTotal * $order->conversion_rate, 2)); ?>

                                                        <?php echo e($order->payable_currency); ?>

                                                    </div>

                                                </div>
                                                <div class="invoice-detail-item">
                                                    <div class="invoice-detail-name"><?php echo e(__('Gateway Charge')); ?>

                                                        (<?php echo e(number_format($gatewayCharge)); ?>%)</div>
                                                    <div class="invoice-detail-value">
                                                        <?php echo e(number_format($order->gateway_charge, 2)); ?>

                                                        <?php echo e($order->payable_currency); ?>

                                                    </div>
                                                </div>
                                                <hr class="mt-2 mb-2">
                                                <div class="invoice-detail-item">
                                                    <div class="invoice-detail-name"><?php echo e(__('Total')); ?></div>
                                                    <div class="invoice-detail-value invoice-detail-value-lg">
                                                        <?php echo e($total); ?> <?php echo e($order->payable_currency); ?>

                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <?php
                                                    $subTotal = 0;
                                                    $discount = 0;
                                                    $gatewayCharge = 0;
                                                    foreach ($order->orderItems as $item) {
                                                        $subTotal += $item->price;
                                                    }
                                                    $subTotalWithConversion = $subTotal * $order->conversion_rate;

                                                    if ($order->coupon_discount_amount > 0) {
                                                        $discount = $order->coupon_discount_amount;
                                                    }

                                                    if ($order->gateway_charge > 0) {
                                                        $gatewayCharge =
                                                            ($order->gateway_charge /
                                                                ($subTotalWithConversion - $discount)) *
                                                            100;
                                                    }

                                                    $total = number_format(
                                                        $subTotalWithConversion - $discount + $order->gateway_charge,
                                                        2,
                                                    );
                                                ?>
                                                <div class="invoice-detail-item">
                                                    <div class="invoice-detail-name"><?php echo e(__('Subtotal')); ?></div>
                                                    <div class="invoice-detail-value">
                                                        <?php echo e(number_format($subTotal * $order->conversion_rate, 2)); ?>

                                                        <?php echo e($order->payable_currency); ?>

                                                    </div>

                                                </div>

                                                <div class="invoice-detail-item">
                                                    <div class="invoice-detail-name"><?php echo e(__('Discount')); ?></div>
                                                    <div class="invoice-detail-value">
                                                        <?php echo e(number_format($discount, 2)); ?>

                                                        <?php echo e($order->payable_currency); ?>

                                                    </div>
                                                </div>
                                                <div class="invoice-detail-item">
                                                    <div class="invoice-detail-name"><?php echo e(__('Gateway Charge')); ?>

                                                        (<?php echo e(number_format($gatewayCharge)); ?>%)</div>
                                                    <div class="invoice-detail-value">
                                                        <?php echo e(number_format($order->gateway_charge, 2)); ?>

                                                        <?php echo e($order->payable_currency); ?>

                                                    </div>
                                                </div>
                                                <hr class="mt-2 mb-2">
                                                <div class="invoice-detail-item">
                                                    <div class="invoice-detail-name"><?php echo e(__('Total')); ?></div>
                                                    <div class="invoice-detail-value invoice-detail-value-lg">
                                                        <?php echo e($total); ?> <?php echo e($order->payable_currency); ?>

                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <hr>
                        <div class="text-md-right">

                            <a target="_blank" href="<?php echo e(route('student.order.print-invoice', $order->id)); ?>"
                                class="btn btn-warning btn-icon icon-left print-btn"><i class="fas fa-print"></i>
                                <?php echo e(__('Print')); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.student-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\student-dashboard\order\show.blade.php ENDPATH**/ ?>