<div class="tab-pane fade active show" id="general_tab" role="tabpanel">
    <form action="<?php echo e(route('admin.update-general-setting')); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <div class="form-group">
            <label for=""><?php echo e(__('App Name')); ?></label>
            <input type="text" name="app_name" class="form-control" value="<?php echo e($setting->app_name); ?>">
        </div>
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for=""><?php echo e(__('Site Address')); ?></label>
                    <input type="text" name="site_address" class="form-control" value="<?php echo e($setting?->site_address); ?>">
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for=""><?php echo e(__('Site Email')); ?></label>
                    <input type="text" name="site_email" class="form-control" value="<?php echo e($setting?->site_email); ?>">
                </div>
            </div>
        </div>
        <div class="form-group">
            <label for=""><?php echo e(__('Timezone')); ?></label>
            <select name="timezone" id="" class="form-control select2">
                <?php $__currentLoopData = $all_timezones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $timezone): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($timezone->name); ?>" <?php if($setting->timezone == $timezone->name): echo 'selected'; endif; ?>>
                        <?php echo e($timezone->name); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
            <div class="form-group">
                <label for=""><?php echo e(__('Mail send time before the live class starts')); ?> <code>(<?php echo e(__('in minutes')); ?>)</code></label>
                <input type="number" name="live_mail_send" class="form-control" value="<?php echo e($setting?->live_mail_send); ?>">
            </div>

        <div class="form-group mb-0">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="header_topbar_status" class="custom-switch-input">
                <input type="checkbox" value="active" name="header_topbar_status"
                    class="custom-switch-input" <?php echo e($setting?->header_topbar_status == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span
                    class="custom-switch-description"><?php echo e(__('Header Topbar')); ?></span>
            </label>
        </div>
        <div class="form-group mb-0">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="header_social_status" class="custom-switch-input">
                <input type="checkbox" value="active" name="header_social_status"
                    class="custom-switch-input" <?php echo e($setting?->header_social_status == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span
                    class="custom-switch-description"><?php echo e(__('Topbar Social Icons')); ?></span>
            </label>
        </div>
        <div class="form-group mb-0">
            <label class="d-flex align-items-center">
                <input type="hidden" value="0" name="preloader_status" class="custom-switch-input">
                <input type="checkbox" value="1" name="preloader_status"
                    class="custom-switch-input" <?php echo e($setting?->preloader_status == 1 ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span
                    class="custom-switch-description"><?php echo e(__('Preloader')); ?></span>
            </label>
        </div>
        <div class="form-group mb-0">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="cursor_dot_status" class="custom-switch-input">
                <input type="checkbox" value="active" name="cursor_dot_status"
                    class="custom-switch-input" <?php echo e($setting?->cursor_dot_status == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span
                    class="custom-switch-description"><?php echo e(__('Cursor Style')); ?></span>
            </label>
        </div>

        <div class="form-group">
            <label class="d-flex align-items-center">
                <input type="hidden" value="inactive" name="is_queable" class="custom-switch-input">
                <input type="checkbox" value="active" name="is_queable"
                    class="custom-switch-input" <?php echo e($setting?->is_queable == 'active' ? 'checked' : ''); ?>>
                <span class="custom-switch-indicator"></span>
                <span
                    class="custom-switch-description"><?php echo e(__('Send Mails In Queue')); ?></span>
            </label>
            <?php if($setting->is_queable == 'active'): ?>
                <div class="pt-1 text-info"><span class="text-success "><?php echo e(__('Copy and Run This Command')); ?>:
                    </span>
                    <strong id="copyCronText" onclick="copyText()" title="<?php echo e(__('Click to copy')); ?>"
                        onmouseover="this.style.cursor='pointer'">php artisan schedule:run >>
                        /dev/null
                        2>&1</strong>
                </div>
                <div class="pt-1 text-warning">
                    <b><?php echo e(__('If enabled, you must setup cron job in your server. otherwise it will not work and no mail will
                                        be sent')); ?></b>
                </div>
            <?php endif; ?>
        </div>

        <button class="btn btn-primary" type="submit"><?php echo e(__('Update')); ?></button>

    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules/GlobalSetting\resources/views/settings/sections/general.blade.php ENDPATH**/ ?>