<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Assign Role')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.role.index')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Assign Role')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a
                            href="<?php echo e(route('admin.role.index')); ?>"><?php echo e(__('Manage Roles')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Assign Role')); ?></div>
                </div>
            </div>

            <div class="section-body">
                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Assign Role')); ?></h4>
                                <div>
                                    <?php if(auth()->guard('admin')->user()->can('role.view', 'admin')): ?>
                                        <a href="<?php echo e(route('admin.role.index')); ?>" class="btn btn-primary"><i
                                                class="fa fa-arrow-left"></i> <?php echo e(__('Back')); ?></a>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="card-body">
                                <form role="form" action="<?php echo e(route('admin.role.assign.update')); ?>" method="POST">
                                    <div class="row">
                                        <div class="col-md-8 offset-md-2">
                                            <?php echo method_field('PUT'); ?>
                                            <?php echo csrf_field(); ?>
                                            <div class="form-group">
                                                <label for="user"><?php echo e(__('Select Admin')); ?> <span
                                                        class="text-danger">*</span></label>
                                                <select name="user_id" id="user"
                                                    class="form-control select2 <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                                    <option value=""><?php echo e(__('Select Admin')); ?></option>
                                                    <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($admin->id); ?>"><?php echo e($admin->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['user_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="invalid-feedback"
                                                        role="alert"><strong><?php echo e($message); ?></strong></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="form-group">
                                                <label for="role"><?php echo e(__('Role')); ?> <span
                                                        class="text-danger">*</span></label>
                                                <select name="role[]" id="role"
                                                    class="form-control select2 <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                                    multiple>
                                                    <option value="" disabled><?php echo e(__('Select Role')); ?></option>
                                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($role->name); ?>"><?php echo e($role->name); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="text-center col-md-8 offset-md-2">
                                            <?php if (isset($component)) { $__componentOriginalf3ad9c349c70d58844f8581b0990debd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3ad9c349c70d58844f8581b0990debd = $attributes; } ?>
<?php $component = App\View\Components\Admin\UpdateButton::resolve(['text' => __('Update')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.update-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\UpdateButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $attributes = $__attributesOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $component = $__componentOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__componentOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict"
        $('#user').on('change', function(e) {
            var id = $(this).val();
            if (id) {
                $.ajax({
                    type: "post",
                    data: {
                        _token: '<?php echo e(csrf_token()); ?>',
                    },
                    url: "<?php echo e(url('/admin/role/assign')); ?>" + "/" + id,
                    beforeSend: function() {
                        $('#update-btn').prop('disabled', true);
                    },
                    success: function(response) {
                        if (response.success) {
                            $('#role').empty();
                            $('#role').append(response.data);
                        }
                        $('#update-btn').prop('disabled', false);
                    },
                    error: function(err) {
                        $('#update-btn').prop('disabled', false);
                        toastr.error("<?php echo e(__('Failed!')); ?>")
                        console.log(err);
                    },
                })
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views/admin/roles/assign-role.blade.php ENDPATH**/ ?>