<?php $__env->startSection('title'); ?>
    <title><?php echo e($title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e($title); ?></h1>
            </div>

            <div class="section-body">
                <div class="row">

                    <div class="col-12 col-md-12 col-lg-12">
                        <div class="card">
                            <div class="card-body text-center">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <tr>
                                            <th><?php echo e(__('SN')); ?></th>
                                            <th><?php echo e(__('User')); ?></th>
                                            <th><?php echo e(__('Order Id')); ?></th>
                                            <th><?php echo e(__('Paid Amount')); ?></th>
                                            <th><?php echo e(__('Gateway')); ?></th>
                                            <th><?php echo e(__('Status')); ?></th>
                                            <th><?php echo e(__('Payment')); ?></th>
                                            <th><?php echo e(__('Action')); ?></th>
                                        </tr>

                                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e(++$index); ?></td>
                                                <td><a
                                                        href="<?php echo e(route('admin.customer-show', $order->buyer_id)); ?>"><?php echo e($order?->user?->name); ?></a>
                                                </td>
                                                <td>#<?php echo e($order->invoice_id); ?></td>
                                                <td><?php echo e($order->paid_amount); ?> <?php echo e($order->payable_currency); ?></td>
                                                <td>
                                                    <?php echo e($order->payment_method); ?>

                                                </td>
                                                <td>
                                                    <?php if($order->status == 'completed'): ?>
                                                        <div class="badge badge-success"><?php echo e(__('Completed')); ?></div>
                                                    <?php elseif($order->status == 'processing'): ?>
                                                        <div class="badge badge-warning"><?php echo e(__('Processing')); ?></div>
                                                    <?php elseif($order->status == 'declined'): ?>
                                                        <div class="badge badge-danger"><?php echo e(__('Declined')); ?></div>
                                                    <?php else: ?>
                                                        <div class="badge badge-warning"><?php echo e(__('Pending')); ?></div>
                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <?php if($order->payment_status == 'paid'): ?>
                                                        <div class="badge badge-success"><?php echo e(__('Paid')); ?></div>
                                                    <?php elseif($order->payment_status == 'cancelled'): ?>
                                                        <div class="badge badge-danger"><?php echo e(__('Cancelled')); ?></div>
                                                    <?php else: ?>
                                                        <div class="badge badge-danger"><?php echo e(__('Pending')); ?></div>
                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <a href="<?php echo e(route('admin.order', $order->id)); ?>"
                                                        class="btn btn-primary btn-sm"><i class="fa fa-eye"></i></a>

                                                    <a href=""
                                                        data-url="<?php echo e(route('admin.order.destroy', $order->id)); ?>"
                                                        class="btn btn-danger btn-sm delete"><i class="fa fa-trash"></i></a>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __('Orders'),'route' => '','create' => 'no','message' => __('No data found!'),'colspan' => '9'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                        <?php endif; ?>
                                    </table>
                                </div>
                                <?php echo e($orders->links()); ?>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <div class="modal fade" tabindex="-1" role="dialog" id="delete">
        <div class="modal-dialog" role="document">
            <form action="" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title"><?php echo e(__('Delete Plan')); ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p class="text-danger"><?php echo e(__('Are You Sure to Delete this Plan ?')); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-danger"><?php echo e(__('Yes, Delete')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <?php $__env->startPush('js'); ?>
        <script>
            $(function() {
                'use strict'

                $('.delete').on('click', function(e) {
                    e.preventDefault();
                    const modal = $('#delete');
                    modal.find('form').attr('action', $(this).data('url'));
                    modal.modal('show');
                })
            })
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Order\resources\views\pending-orders.blade.php ENDPATH**/ ?>