<section class="blog__post-area">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section__title text-center mb-40">
                    <span class="sub-title"><?php echo e(__('News & Blogs')); ?></span>
                    <h2 class="title"><?php echo e(__('Our Latest News Feed')); ?></h2>
                    <p><?php echo e(__('Dont Miss Stay Updated with the Latest Articles and Insights')); ?></p>
                </div>
            </div>
        </div>
        <div class="row gutter-20">
            <?php $__currentLoopData = $featuredBlogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xxl-3 col-md-6 col-lg-4">
                    <div class="blog__post-item shine__animate-item">
                        <div class="blog__post-thumb">
                            <a href="<?php echo e(route('blog.show', $blog->slug)); ?>" class="shine__animate-link blog"><img src="<?php echo e(asset($blog->image)); ?>"
                                    alt="img"></a>
                            <a href="<?php echo e(route('blogs', ['category' => $blog->category->slug])); ?>"
                                class="post-tag"><?php echo e($blog->category?->title); ?></a>
                        </div>
                        <div class="blog__post-content">
                            <div class="blog__post-meta">
                                <ul class="list-wrap">
                                    <li><i class="flaticon-calendar"></i><?php echo e(formatDate($blog->created_at)); ?></li>
                                    <li><i class="flaticon-user-1"></i><?php echo e(__('by')); ?> <a
                                            href="javascript:;"><?php echo e(truncate($blog->author->name, 14)); ?></a>
                                    </li>
                                </ul>
                            </div>
                            <h3 class="title"><a
                                    href="<?php echo e(route('blog.show', $blog->slug)); ?>"><?php echo e(truncate($blog?->title, 50)); ?></a>
                            </h3>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views/frontend/home/main/sections/blog-area.blade.php ENDPATH**/ ?>