<?php
    $method = $paymentMethod;
    $razorpay_key = $paymentService->getGatewayDetails($method)->razorpay_key ?? '';
    $razorpay_name = $paymentService->getGatewayDetails($method)->razorpay_name ?? '';
    $razorpay_description = $paymentService->getGatewayDetails($method)->razorpay_description ?? '';
    $razorpay_image = $paymentService->getGatewayDetails($method)->razorpay_image ?? '';
    $razorpay_theme_color = $paymentService->getGatewayDetails($method)->razorpay_theme_color ?? '';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Razorpay Checkout</title>
    <style>
        .razorpay-payment-button{
            display: none;
        }
    </style>
</head>

<body>
    <form action="<?php echo e(isset($token) ? route('payment-api.razorpay-webview', ['bearer_token' => $token, 'order_id' => $order_id]) : route('pay-via-razorpay')); ?>" method="POST" class="d-none">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="payable_amount" value="<?php echo e(session('paid_amount')); ?>">
        <script src="https://checkout.razorpay.com/v1/checkout.js" data-key="<?php echo e($razorpay_key); ?>"
            data-currency="<?php echo e(session('payable_currency')); ?>" data-amount="<?php echo e(session('paid_amount') * 100); ?>"
            data-buttontext="" data-name="<?php echo e($razorpay_name); ?>"
            data-description="<?php echo e($razorpay_description); ?>" data-image="<?php echo e(asset($razorpay_image)); ?>"
            data-prefill.name="<?php echo e(auth()->user()?->name); ?>" data-prefill.email="<?php echo e(auth()->user()?->email); ?>"
            data-theme.color="<?php echo e($razorpay_theme_color); ?>"></script>
    </form>
    <script>
        "use strict";
        document.addEventListener('DOMContentLoaded', function() {
            var razorpayButton = document.querySelector('.razorpay-payment-button');
            if (razorpayButton) {
                razorpayButton.click();
            }
        });
    </script>
</body>

</html>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\gateway-actions\razorpay.blade.php ENDPATH**/ ?>