<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('User Details')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('User Details')); ?></h1>
            </div>

            <div class="section-body">
                <div class="row">
                    <div class="col-lg-3">
                        <div class="card shadow">
                            <?php if($user->image): ?>
                                <img src="<?php echo e(asset($user->image)); ?>" class="profile_img w-100">
                            <?php else: ?>
                                <img src="<?php echo e(asset($setting->default_avatar)); ?>" class="w-100">
                            <?php endif; ?>

                            <div class="container my-3">
                                <h4><?php echo e(html_decode($user->name)); ?></h4>

                                <?php if($user->phone): ?>
                                    <p class="title"><?php echo e(html_decode($user->phone)); ?></p>
                                <?php endif; ?>

                                <p class="title"><?php echo e(html_decode($user->email)); ?></p>

                                <p class="title"><?php echo e(__('Joined')); ?> : <?php echo e($user->created_at->format('h:iA, d M Y')); ?></p>

                                <?php if($user->is_banned == 'yes'): ?>
                                    <p class="title"><?php echo e(__('Banned')); ?> : <b><?php echo e(__('Yes')); ?></b></p>
                                <?php else: ?>
                                    <p class="title"><?php echo e(__('Banned')); ?> : <b><?php echo e(__('No')); ?></b></p>
                                <?php endif; ?>

                                <?php if($user->email_verified_at): ?>
                                    <p class="title"><?php echo e(__('Email verified')); ?> : <b><?php echo e(__('Yes')); ?></b> </p>
                                <?php else: ?>
                                    <p class="title"><?php echo e(__('Email verified')); ?> : <b><?php echo e(__('None')); ?></b> </p>

                                    <a href="javascript:;" data-toggle="modal" data-target="#verifyModal"
                                        class="btn btn-success my-2 text-capitalize"><?php echo e(__('Send Verify Link to Mail')); ?></a>
                                    <?php if(auth()->guard('admin')->user()->can('customer.update')): ?>
                                        <a href="<?php echo e(route('admin.verify-account-manually', $user->id)); ?>"
                                            class="btn btn-success my-2 text-capitalize"><?php echo e(__('Verify Account')); ?></a>
                                    <?php endif; ?>
                                <?php endif; ?>

                                <a href="javascript:;" data-toggle="modal" data-target="#sendMailModal"
                                    class="btn btn-primary sendMail my-2"><?php echo e(__('Send Mail To User')); ?></a>

                                <?php if($user->is_banned == 'yes'): ?>
                                    <a href="javascript:;" data-toggle="modal" data-target="#bannedModal"
                                        class="btn btn-warning my-2"><?php echo e(__('Remove Ban')); ?></a>
                                <?php else: ?>
                                    <a href="javascript:;" data-toggle="modal" data-target="#bannedModal"
                                        class="btn btn-warning my-2"><?php echo e(__('Ban User')); ?></a>
                                <?php endif; ?>

                                <?php if($user->role != 'instructor'): ?>
                                    <a onclick="deleteData(<?php echo e($user->id); ?>)" href="javascript:;" data-toggle="modal"
                                        data-target="#deleteModal" class="btn btn-danger"><?php echo e(__('Delete Account')); ?></a>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>

                    <div class="col-md-9">
                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="service_card"><?php echo e(__('Profile Information')); ?></h5>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.customer-info-update', $user->id)); ?>" method="post"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="name"><?php echo e(__('Full Name')); ?> <code>*</code></label>
                                                <input id="name" name="name" type="text"
                                                    value="<?php echo e($user->name); ?>" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="email"><?php echo e(__('Email')); ?> <code>*</code></label>
                                                <input id="email" name="email" type="email"
                                                    value="<?php echo e($user->email); ?>" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="phone"><?php echo e(__('phone')); ?></label>
                                                <input id="phone" name="phone" type="text"
                                                    value="<?php echo e($user->phone); ?>" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="gender"><?php echo e(__('Gender')); ?></label>
                                                <select name="gender" id="gender" class="form-control">
                                                    <option value=""><?php echo e(__('Select')); ?></option>
                                                    <option <?php if($user->gender == 'male'): echo 'selected'; endif; ?> value="male"><?php echo e(__('Male')); ?>

                                                    </option>
                                                    <option <?php if($user->gender == 'female'): echo 'selected'; endif; ?> value="female"><?php echo e(__('Female')); ?>

                                                    </option>
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="age"><?php echo e(__('Age')); ?></label>
                                                <input id="age" name="age" type="text"
                                                    value="<?php echo e($user->age); ?>" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-12 mt-4">
                                            <button type="submit"
                                                class="btn btn-primary w-100"><?php echo e(__('Update Profile')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="service_card"><?php echo e(__('Profile Biography')); ?></h5>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.customer-bio-update', $user->id)); ?>" method="post"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="row">

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="designation"><?php echo e(__('Designation')); ?> <code>*</code></label>
                                                <input id="designation" name="designation" type="text"
                                                    value="<?php echo e($user->job_title); ?>" class="form-control">
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="short-bio"><?php echo e(__('Short Bio')); ?> <code>*</code></label>
                                                <textarea id="short-bio" name="short_bio" class="form-control"><?php echo e($user->short_bio); ?></textarea>

                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="bio"><?php echo e(__('Bio')); ?> <code>*</code></label>
                                                <textarea id="bio" name="bio" class="form-control"><?php echo e($user->bio); ?></textarea>
                                            </div>
                                        </div>

                                        <div class="col-md-12 mt-4">
                                            <button type="submit"
                                                class="btn btn-primary w-100"><?php echo e(__('Update Profile')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <?php if($user->role == 'instructor'): ?>
                            
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="service_card"><?php echo e(__('Experience and Education')); ?></h5>
                                </div>
                                <div class="card-body">
                                    <!-- Experience -->
                                    <div class="instructor__profile-form-wrap">
                                        <div class="dashboard__content-title d-flex justify-content-between">
                                            <h5 class="title"><?php echo e(__('Experience')); ?></h5>
                                            <button type="button" class="btn btn-primary btn-hight-basic show-modal mb-3"
                                                data-url="<?php echo e(route('admin.customer-experience-modal', $user->id)); ?>">
                                                <?php echo e(__('Add Experience')); ?>

                                            </button>

                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="dashboard__review-table table-responsive">
                                                    <table class="table table-borderless">
                                                        <thead>
                                                            <tr>
                                                                <th><?php echo e(__('No')); ?></th>
                                                                <th><?php echo e(__('Company')); ?></th>
                                                                <th><?php echo e(__('Position')); ?></th>
                                                                <th><?php echo e(__('Start Date')); ?></th>
                                                                <th><?php echo e(__('End Date')); ?></th>
                                                                <th><?php echo e(__('Action')); ?></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php $__empty_1 = true; $__currentLoopData = $experiences; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $experience): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                                <tr>
                                                                    <td>
                                                                        <p><?php echo e($loop->iteration); ?></p>
                                                                    </td>
                                                                    <td>
                                                                        <p><?php echo e($experience->company); ?></p>
                                                                    </td>
                                                                    <td>
                                                                        <p><?php echo e($experience->position); ?></p>
                                                                    </td>
                                                                    <td>
                                                                        <p><?php echo e($experience->start_date); ?></p>
                                                                    </td>
                                                                    <td>
                                                                        <p><?php echo e($experience->current ? 'Present' : $experience->end_date); ?>

                                                                        </p>
                                                                    </td>
                                                                    <td>
                                                                        <div class="dashboard__review-action">
                                                                            <a href="#"
                                                                                class="show-modal btn btn-primary btn-sm m-1"
                                                                                data-url="<?php echo e(route('admin.customer-edit-experience-modal', $experience->id)); ?>"
                                                                                title="Edit"><i
                                                                                    class="far fa-edit"></i></i></a>

                                                                            <a href="javascript:;" data-toggle="modal"
                                                                                data-target="#deleteModal"
                                                                                class="btn btn-danger btn-sm m-1"
                                                                                onclick="deleteExperience(<?php echo e($experience->id); ?>)"><i
                                                                                    class="fa fa-trash"
                                                                                    aria-hidden="true"></i></a>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                                <td colspan="6" class="text-center">
                                                                    <span class="text-muted"><?php echo e(__('No Data!')); ?></span>
                                                                </td>
                                                            <?php endif; ?>

                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                    <br>
                                    <!-- Education -->
                                    <div class="instructor__profile-form-wrap">
                                        <div class="dashboard__content-title d-flex justify-content-between">
                                            <h5 class="title"><?php echo e(__('Education')); ?></h5>
                                            <button type="button" class="btn btn-primary btn-hight-basic show-modal mb-3"
                                                data-url="<?php echo e(route('admin.customer-education-modal', $user->id)); ?>">
                                                <?php echo e(__('Add Education')); ?>

                                            </button>

                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div class="dashboard__review-table table-responsive">
                                                    <table class="table table-borderless">
                                                        <thead>
                                                            <tr>
                                                                <th><?php echo e(__('No')); ?></th>
                                                                <th><?php echo e(__('Organization')); ?></th>
                                                                <th><?php echo e(__('Degree')); ?></th>
                                                                <th><?php echo e(__('Start Date')); ?></th>
                                                                <th><?php echo e(__('End Date')); ?></th>
                                                                <th width="20%"><?php echo e(__('Action')); ?></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <?php $__empty_1 = true; $__currentLoopData = $educations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $education): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                                <tr>
                                                                    <td>
                                                                        <p><?php echo e($loop->iteration); ?></p>
                                                                    </td>
                                                                    <td>
                                                                        <p><?php echo e($education->organization); ?></p>
                                                                    </td>
                                                                    <td>
                                                                        <p><?php echo e($education->degree); ?></p>
                                                                    </td>
                                                                    <td>
                                                                        <p><?php echo e($education->start_date); ?></p>
                                                                    </td>
                                                                    <td>
                                                                        <p><?php echo e($education->current == 1 || $education->end_date == null ? 'Present' : $experience->end_date); ?>

                                                                        </p>
                                                                    </td>

                                                                    <td>
                                                                        <div class="dashboard__review-action">
                                                                            <a href="#"
                                                                                class="show-modal btn btn-primary btn-sm m-1"
                                                                                data-url="<?php echo e(route('admin.customer-edit-education-modal', $education->id)); ?>"
                                                                                title="Edit"><i
                                                                                    class="far fa-edit"></i></i></a>
                                                                            <a href="javascript:;" data-toggle="modal"
                                                                                data-target="#deleteModal"
                                                                                class="btn btn-danger btn-sm m-1"
                                                                                onclick="deleteEducation(<?php echo e($education->id); ?>)"><i
                                                                                    class="fa fa-trash"
                                                                                    aria-hidden="true"></i></a>
                                                                        </div>
                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                                <td colspan="6" class="text-center">
                                                                    <span class="text-muted"><?php echo e(__('No Data!')); ?></span>
                                                                </td>
                                                            <?php endif; ?>

                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="service_card"><?php echo e(__('Profile Location')); ?></h5>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.customer-location-update', $user->id)); ?>" method="POST"
                                    class="instructor__profile-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label for="country"><?php echo e(__('Country')); ?> <code>*</code></label>
                                                <select name="country" id="country" class="country form-control">
                                                    <option value=""><?php echo e(__('Select')); ?></option>
                                                    <?php $__currentLoopData = countries(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option <?php if($user->country_id == $country->id): echo 'selected'; endif; ?> value="<?php echo e($country->id); ?>">
                                                            <?php echo e($country->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-grp">
                                                <label for="state"><?php echo e(__('State')); ?></label>
                                                <input type="text" class="form-control" name="state" id="state"
                                                    value="<?php echo e($user->state); ?>">
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div class="form-grp">
                                                <label for="city"><?php echo e(__('City')); ?></label>
                                                <input type="text" class="form-control" name="city" id="city"
                                                    value="<?php echo e($user->city); ?>">
                                            </div>
                                        </div>


                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="address"><?php echo e(__('Address')); ?></label>
                                                <input id="address" value="<?php echo e($user->address); ?>" type="address"
                                                    name="address" placeholder="<?php echo e(__('Address')); ?>"
                                                    class="form-control">
                                            </div>
                                        </div>

                                    </div>

                                    <button type="submit"
                                        class="btn btn-primary w-100"><?php echo e(__('Update Profile')); ?></button>

                                </form>
                            </div>
                        </div>

                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="service_card"><?php echo e(__('Profile Socials')); ?></h5>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.customer-Social-update', $user->id)); ?>" method="POST"
                                    class="instructor__profile-form">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="form-group">
                                        <label for="facebook"><?php echo e(__('Facebook')); ?></label>
                                        <input id="facebook" name="facebook" type="url"
                                            value="<?php echo e($user->facebook); ?>" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label for="twitter"><?php echo e(__('Twitter')); ?></label>
                                        <input id="twitter" name="twitter" type="url"
                                            value="<?php echo e($user->twitter); ?>" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label for="linkedin"><?php echo e(__('Linkedin')); ?></label>
                                        <input id="linkedin" name="linkedin" type="url"
                                            value="<?php echo e($user->linkedin); ?>" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label for="website"><?php echo e(__('Website')); ?></label>
                                        <input id="website" name="website" type="url"
                                            value="<?php echo e($user->website); ?>" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label for="github"><?php echo e(__('Github')); ?></label>
                                        <input id="github" name="github" type="url"
                                            value="<?php echo e($user->github); ?>" class="form-control">
                                    </div>
                                    <div class="submit-btn">
                                        <button type="submit"
                                            class="btn btn-primary w-100"><?php echo e(__('Update Profile')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>


                        
                        <div class="card">
                            <div class="card-header">
                                <h5 class="service_card"><?php echo e(__('Change Password')); ?></h5>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.customer-password-change', $user->id)); ?>" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="row">
                                        <div class="col-md-6 mb-3">
                                            <label for=""><?php echo e(__('Password')); ?> <span
                                                    class="text-danger">*</span></label>
                                            <input type="password" name="password" class="form-control">
                                        </div>

                                        <div class="col-md-6 mb-3">
                                            <label for=""><?php echo e(__('Confirm Password')); ?> <span
                                                    class="text-danger">*</span></label>
                                            <input type="password" name="password_confirmation" class="form-control">
                                        </div>

                                        <div class="col-md-12 mt-4">
                                            <button type="submit"
                                                class="btn btn-primary w-100"><?php echo e(__('Change Password')); ?></button>
                                        </div>

                                    </div>
                                </form>
                            </div>
                        </div>

                        
                        <?php if($banned_histories->count() > 0): ?>
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="service_card"><?php echo e(__('Banned History')); ?></h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th width="30%"><?php echo e(__('Subject')); ?></th>
                                                <th width="30%"><?php echo e(__('Description')); ?></th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            <?php $__currentLoopData = $banned_histories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banned_history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($banned_history->subject); ?></td>
                                                    <td><?php echo clean(nl2br($banned_history->description)); ?></td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </section>
    </div>

    <!-- Start Banned modal -->
    <div class="modal fade" id="bannedModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="container-fluid">
                        <div class="custom-modal-header">
                            <h5 class="modal-title"><?php echo e(__('Banned request confirmation')); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="<?php echo e(route('admin.send-banned-request', $user->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <div class="form-group">
                                <label for=""><?php echo e(__('Subject')); ?></label>
                                <input type="text" class="form-control" name="subject">
                            </div>

                            <div class="form-group">
                                <label for=""><?php echo e(__('Description')); ?></label>
                                <textarea name="description" class="form-control text-area-5" id="" cols="30" rows="10"></textarea>
                            </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Send Request')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Banned modal -->

    <!-- Start Verify modal -->
    <div class="modal fade" id="verifyModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="container-fluid">
                        <div class="custom-modal-header">
                            <h5 class="modal-title"><?php echo e(__('Send verify link to customer mail')); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <p><?php echo e(__('Are you sure want to send verify link to customer mail?')); ?></p>

                        <form action="<?php echo e(route('admin.send-verify-request', $user->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Send Request')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Verify modal -->

    <!-- Start Send Mail modal -->
    <div class="modal fade" id="sendMailModal" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="container-fluid">
                        <div class="custom-modal-header">
                            <h5 class="modal-title"><?php echo e(__('Send mail to User')); ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <form action="<?php echo e(route('admin.send-mail-to-customer', $user->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>

                            <div class="form-group">
                                <label for=""><?php echo e(__('Subject')); ?></label>
                                <input type="text" class="form-control" name="subject">
                            </div>

                            <div class="form-group">
                                <label for=""><?php echo e(__('Description')); ?></label>
                                <textarea name="description" class="form-control text-area-5" id="" cols="30" rows="10"></textarea>
                            </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Send Mail')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Send Mail modal -->

    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
    <?php $__env->startPush('js'); ?>
        <script>
            function deleteData(id) {
                $("#deleteForm").attr("action", '<?php echo e(url('/admin/customer-delete/')); ?>' + "/" + id)
            }

            function deleteExperience(id) {
                $("#deleteForm").attr("action", '<?php echo e(url('/admin/customer-experience-destroy/')); ?>' + "/" + id)
            }

            function deleteEducation(id) {
                $("#deleteForm").attr("action", '<?php echo e(url('/admin/customer-education-destroy/')); ?>' + "/" + id)
            }
        </script>
    <?php $__env->stopPush(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Customer\resources\views\customer_show.blade.php ENDPATH**/ ?>