<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Category List')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Category List')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a
                            href="<?php echo e(route('admin.blog-category.index')); ?>"><?php echo e(__('Category List')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Edit Category')); ?> (<?php echo e(request('code')); ?>)</div>
                </div>
            </div>
            <div class="section-body row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="service_card"><?php echo e(__('Available Translations')); ?></h5>
                            <?php if(auth()->guard('admin')->user()->can('blog.category.translate')): ?>
                                <hr>
                                <?php if($code !== $languages->first()->code): ?>
                                    <button onclick="translateAll()" class="btn btn-primary"
                                        id="translate-btn"><?php echo e(__('Translate')); ?></button>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <div class="lang_list_top">
                                <ul class="lang_list">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a id="<?php echo e(request('code') == $language->code ? 'selected-language' : ''); ?>"
                                                href="<?php echo e(route('admin.blog-category.edit', ['blog_category' => $category->id, 'code' => $language->code])); ?>"><i
                                                    class="fas <?php echo e(request('code') == $language->code ? 'fa-eye' : 'fa-edit'); ?>"></i>
                                                <?php echo e($language->name); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div class="mt-2 alert alert-danger" role="alert">
                                <?php
                                    $current_language = $languages->where('code', request()->get('code'))->first();
                                ?>
                                <p><?php echo e(__('Your editing mode')); ?> :
                                    <b><?php echo e($current_language?->name); ?></b>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Edit Category')); ?></h4>
                                <div>
                                    <a href="<?php echo e(route('admin.blog-category.index')); ?>" class="btn btn-primary"><i
                                            class="fa fa-arrow-left"></i><?php echo e(__('Back')); ?></a>
                                </div>
                            </div>
                            <div class="card-body">
                                <form
                                    action="<?php echo e(route('admin.blog-category.update', ['blog_category' => $category->id, 'code' => $code])); ?>"
                                    method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="col-md-8 offset-md-2">
                                            <div class="form-group">
                                                <label for="title"><?php echo e(__('Title')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="title" name="title"
                                                    value="<?php echo e(old('title', $category->getTranslation($code)->title)); ?>"
                                                    placeholder="<?php echo e(__('Enter Title')); ?>" class="form-control">
                                                <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <?php if($code == $languages->first()->code): ?>
                                            <div class="col-md-8 offset-md-2">
                                                <div class="form-group">
                                                    <label for="slug"><?php echo e(__('Slug')); ?><span
                                                            class="text-danger">*</span></label>
                                                    <input type="text" id="slug" name="slug"
                                                        value="<?php echo e(old('slug', $category->slug)); ?>"
                                                        placeholder="<?php echo e(__('Enter Slug')); ?>" class="form-control">
                                                    <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <span class="text-danger"><?php echo e($message); ?></span>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="text-center offset-md-2 col-md-8">
                                            <?php if (isset($component)) { $__componentOriginalf3ad9c349c70d58844f8581b0990debd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3ad9c349c70d58844f8581b0990debd = $attributes; } ?>
<?php $component = App\View\Components\Admin\UpdateButton::resolve(['text' => __('Update')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.update-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\UpdateButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $attributes = $__attributesOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $component = $__componentOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__componentOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php if($code == $languages->first()->code): ?>
    <?php $__env->startPush('js'); ?>
        <script>
            (function($) {
                "use strict";
                $(document).ready(function() {
                    $("#title").on("keyup", function(e) {
                        $("#slug").val(convertToSlug($(this).val()));
                    })
                });
            })(jQuery);

            function convertToSlug(Text) {
                return Text
                    .toLowerCase()
                    .replace(/[^\w ]+/g, '')
                    .replace(/ +/g, '-');
            }
        </script>
    <?php $__env->stopPush(); ?>
<?php else: ?>
    <?php $__env->startPush('js'); ?>
        <script>
            var isTranslatingInputs = true;

            function translateOneByOne(inputs, index = 0) {
                if (index >= inputs.length) {
                    if (isTranslatingInputs) {
                        isTranslatingInputs = false;
                        translateAllTextarea();
                    }
                    $('#translate-btn').prop('disabled', false);
                    $('#update-btn').prop('disabled', false);
                    return;
                }

                var $input = $(inputs[index]);
                var inputValue = $input.val();

                if (inputValue) {
                    $.ajax({
                        url: "<?php echo e(route('admin.languages.update.single')); ?>",
                        type: "POST",
                        data: {
                            lang: '<?php echo e($code); ?>',
                            text: inputValue,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        dataType: 'json',
                        beforeSend: function() {
                            $input.prop('disabled', true);
                            iziToast.show({
                                timeout: false,
                                close: true,
                                theme: 'dark',
                                icon: 'loader',
                                iconUrl: 'https://hub.izmirnic.com/Files/Images/loading.gif',
                                title: "<?php echo e(__('Translation Processing, please wait...')); ?>",
                                position: 'center',
                            });
                        },
                        success: function(response) {
                            $input.val(response);
                            $input.prop('disabled', false);
                            iziToast.destroy();
                            toastr.success("<?php echo e(__('Translated Successfully!')); ?>");
                            translateOneByOne(inputs, index + 1);
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            console.error(textStatus, errorThrown);
                            iziToast.destroy();
                            toastr.error('Error', 'Error');
                        }
                    });
                } else {
                    translateOneByOne(inputs, index + 1);
                }
            }

            function translateAll() {
                iziToast.question({
                    timeout: 20000,
                    close: false,
                    overlay: true,
                    displayMode: 'once',
                    id: 'question',
                    zindex: 999,
                    title: "<?php echo e(__('This will take a while!')); ?>",
                    message: "<?php echo e(__('Are you sure?')); ?>",
                    position: 'center',
                    buttons: [
                        ["<button><b><?php echo e(__('YES')); ?></b></button>", function(instance, toast) {
                            var isDemo = "<?php echo e(env('PROJECT_MODE') ?? 1); ?>";

                            if (isDemo == 0) {
                                instance.hide({
                                    transitionOut: 'fadeOut'
                                }, toast, 'button');
                                toastr.error("<?php echo e(__('This Is Demo Version. You Can Not Change Anything')); ?>");
                                return;
                            }

                            $('#translate-btn').prop('disabled', true);
                            $('#update-btn').prop('disabled', true);

                            instance.hide({
                                transitionOut: 'fadeOut'
                            }, toast, 'button');

                            var inputs = $('input[data-translate="true"]').toArray();
                            translateOneByOne(inputs);

                        }, true],
                        ["<button><?php echo e(__('NO')); ?></button>", function(instance, toast) {

                            instance.hide({
                                transitionOut: 'fadeOut'
                            }, toast, 'button');

                        }],
                    ],
                    onClosing: function(instance, toast, closedBy) {},
                    onClosed: function(instance, toast, closedBy) {}
                });
            };

            function translateAllTextarea() {
                var inputs = $('textarea[data-translate="true"]').toArray();
                if (inputs.length === 0) {
                    return;
                }
                translateOneByOne(inputs);
            }

            $(document).ready(function() {
                var selectedTranslation = $('#selected-language').text();
                var btnText = "<?php echo e(__('Translate to')); ?>" + selectedTranslation;
                $('#translate-btn').text(btnText);
            });
        </script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Blog\resources\views\Category\edit.blade.php ENDPATH**/ ?>