<div class="modal-header">
    <h6 class="modal-title fs-5" id=""><?php echo e(__('Update Lesson')); ?></h6>
</div>

<div class="p-3">
    <form action="<?php echo e(route('admin.course-chapter.lesson.update')); ?>" method="POST"
        class="update_lesson_form instructor__profile-form">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="course_id" value="<?php echo e($courseId); ?>">
        <input type="hidden" name="chapter_item_id" value="<?php echo e($chapterItem->id); ?>">
        <input type="hidden" name="type" value="<?php echo e($chapterItem->type); ?>">

        <div>
            <div class="form-group">
                <label for="chapter"><?php echo e(__('Chapter')); ?> <code>*</code></label>
                <select name="chapter" id="chapter" class="chapter form-control">
                    <option value=""><?php echo e(__('Select')); ?></option>
                    <?php $__currentLoopData = $chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php if($chapterItem->chapter_id == $chapter->id): echo 'selected'; endif; ?> value="<?php echo e($chapter->id); ?>"><?php echo e($chapter->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <div>
            <div class="form-group">
                <label for="title"><?php echo e(__('Title')); ?> <code>*</code></label>
                <input id="title" name="title" type="text" value="<?php echo e($chapterItem->lesson->title); ?>"
                    class="form-control">
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-grp">
                    <label for="source"><?php echo e(__('Source')); ?> <code>*</code></label>
                    <select name="source" id="source" class="source form-control">
                        <option value=""><?php echo e(__('Select')); ?></option>
                        <?php if($setting?->aws_status == 'active'): ?>
                            <option <?php if($chapterItem->lesson->storage == "aws"): echo 'selected'; endif; ?> value="aws"><?php echo e(config('course.storage_source.aws')); ?></option>
                        <?php endif; ?>
                        <?php $__currentLoopData = config('course.storage_source'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($key != 'aws' && $key != 'wasabi'): ?>
                                <option <?php if($chapterItem->lesson->storage == $key): echo 'selected'; endif; ?> value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($setting?->wasabi_status == 'active'): ?>
                            <option <?php if($chapterItem->lesson->storage == "wasabi"): echo 'selected'; endif; ?> value="wasabi"><?php echo e(config('course.storage_source.wasabi')); ?></option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="file_type"><?php echo e(__('File Type')); ?> <code>*</code></label>
                    <select name="file_type" id="file_type" class="file_type form-control">
                        <option value=""><?php echo e(__('Select')); ?></option>
                        <?php $__currentLoopData = config('course.file_types'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(in_array($key, ['video', 'file', 'other'])): ?>
                                <option <?php if($chapterItem->lesson->file_type == $key): echo 'selected'; endif; ?> value="<?php echo e($key); ?>"><?php echo e($value); ?>

                                </option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="col-md-8 upload <?php echo e($chapterItem->lesson->storage == 'upload' ? '' : 'd-none'); ?>">
                <div class="from-group mb-3">
                    <label class="form-file-manager-label" for=""><?php echo e(__('Path')); ?>

                        <code>*</code></label>
                    <div class="input-group">
                        <span class="input-group-text" id="basic-addon1">
                            <a data-input="path" data-preview="holder" class="file-manager">
                                <i class="fa fa-picture-o"></i> <?php echo e(__('Choose')); ?>

                            </a>
                        </span>
                        <input id="path" readonly class="form-control file-manager-input" type="text"
                            name="upload_path"
                            value="<?php echo e($chapterItem->lesson->storage == 'upload' ? $chapterItem->lesson->file_path : ''); ?>">
                    </div>
                </div>
            </div>
            <div class="col-md-12 cloud_storage <?php echo e($chapterItem->lesson->storage != 'wasabi' || $chapterItem->lesson->storage != 'aws' ? 'd-none' : ''); ?>">
                <div class="from-group mb-3">
                    <label class="form-file-manager-label" for=""><?php echo e(__('Upload')); ?></label>
                    <div class="input-group">
                        <div class="input-group">
                            <input id="file-input" type="file" class="form-control">
                            <button type="button" id="cloud-btn" class="input-group-text" id="basic-addon1"><i class="fas fa-upload"></i></button>
                        </div>
                    </div>
                    <div class="progress d-none">
                        <div class="progress-bar progress-bar-striped progress-bar-animated w-100" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-8 link_path <?php echo e($chapterItem->lesson->storage != 'upload' ? '' : 'd-none'); ?>">
                <div class="form-grp">
                    <label for="meta_description"><?php echo e(__('Path')); ?> <code></code></label>
                    <div class="input-group mb-3">
                        <span class="input-group-text" id="basic-addon1"><i class="fas fa-link"></i></span>
                        <input type="text" class="form-control" id="input_link" name="link_path"
                            placeholder="<?php echo e(__('peste source url')); ?>"
                            value="<?php echo e($chapterItem->lesson->storage != 'upload' ? $chapterItem->lesson->file_path : ''); ?>" <?php echo e($chapterItem->lesson->storage == 'wasabi' || $chapterItem->lesson->storage == 'aws' ? 'readonly' : ''); ?>>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="duration"><?php echo e(__('Duration')); ?> <code>* (<?php echo e(__('in minutes')); ?>)</code></label>
                    <input class="form-control" id="duration" name="duration" type="text"
                        value="<?php echo e($chapterItem->lesson->duration); ?>">
                </div>
            </div>
        </div>

        <div>
            <div class="form-group">
                <label for="description"><?php echo e(__('Description')); ?> <code></code></label>
                <textarea name="description" class="form-control"><?php echo e($chapterItem->lesson->description); ?></textarea>
            </div>
        </div>
        <div class="row is_free_wrapper">
            <div class="col-md-6 mt-2">
                <span><?php echo e(__('Preview')); ?></span>
                <div class="switcher ms-3">
                    <label for="toggle-0">
                        <input <?php if($chapterItem->lesson->is_free): echo 'checked'; endif; ?> type="checkbox" id="toggle-0" value="1"
                            name="is_free" />
                        <span><small></small></span>
                    </label>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary submit-btn"><?php echo e(__('Update')); ?></button>
        </div>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\Course\resources\views\course\partials\lesson-edit-modal.blade.php ENDPATH**/ ?>