<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Contact Page Section')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Contact Page Section')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Contact Page Section')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Update Contact Section')); ?></h4>

                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.contact-section.update', 1)); ?>" method="post"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for="title"><?php echo e(__('Address')); ?><span
                                                        class="text-danger"></span></label>
                                                <input data-translate="true" type="text" id="title" name="address"
                                                    value="<?php echo e($contact?->address); ?>" placeholder="<?php echo e(__('Title')); ?>"
                                                    class="form-control">
                                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Phone One')); ?><span
                                                        class="text-danger"></span></label>
                                                <input data-translate="true" type="text" id="title" name="phone_one"
                                                    value="<?php echo e($contact?->phone_one); ?>" placeholder="<?php echo e(__('Phone One')); ?>"
                                                    class="form-control">
                                                <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Phone Two')); ?><span
                                                        class="text-danger"></span></label>
                                                <input data-translate="true" type="text" id="title" name="phone_two"
                                                    value="<?php echo e($contact?->phone_two); ?>" placeholder="<?php echo e(__('Phone Two')); ?>"
                                                    class="form-control">
                                                <?php $__errorArgs = ['two'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Email One')); ?><span
                                                        class="text-danger"></span></label>
                                                <input data-translate="true" type="text" id="title" name="email_one"
                                                    value="<?php echo e($contact?->email_one); ?>" placeholder="<?php echo e(__('Email One')); ?>"
                                                    class="form-control">
                                                <?php $__errorArgs = ['email_one'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Email Two')); ?><span
                                                        class="text-danger"></span></label>
                                                <input data-translate="true" type="text" id="title" name="email_two"
                                                    value="<?php echo e($contact?->email_two); ?>" placeholder="<?php echo e(__('Email Two')); ?>"
                                                    class="form-control">
                                                <?php $__errorArgs = ['email_two'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Map Link')); ?><span
                                                        class="text-danger"></span></label>
                                                <input data-translate="true" type="text" id="map" name="map"
                                                    value="<?php echo e(preg_replace('/^https?:\/\//', '', $contact?->map)); ?>"
                                                    placeholder="<?php echo e(__('Map Link')); ?>" class="form-control">
                                                <?php $__errorArgs = ['map'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col">
                                            <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        function cleanUrl() {
            let url = $('#map').val();
            if (url.startsWith('https://')) {
                url = url.replace('https://', '');
            } else if (url.startsWith('http://')) {
                url = url.replace('http://', '');
            }
            $('#map').val(url);
        }

        // Handle input event (typing)
        $('#map').on('input', cleanUrl);

        // Handle paste event
        $('#map').on('paste', function() {
            setTimeout(cleanUrl, 0);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Frontend\resources\views\contact-section.blade.php ENDPATH**/ ?>