<?php $__env->startSection('contents'); ?>
    <section class="wsus__course_video">
        <div class="col-12">
            <div class="wsus__course_header">
                <?php if(Session::has('course_slug')): ?>
                    <a href="<?php echo e(route('student.learning.index', Session::get('course_slug'))); ?>"><i
                            class="fas fa-angle-left"></i><?php echo e(truncate(Session::get('course_title'))); ?></a>
                <?php endif; ?>
            </div>
        </div>

        <div class="container">
            <div class="question-container">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <div class="card text-center">
                            <div class="info-col text-center">
                                <img src="<?php echo e(asset('uploads/website-images/student-grades.png')); ?>">
                            </div>
                            <div class="card-body">
                                <h6 class="card-title count"><?php echo e($quiz->pass_mark); ?>/<?php echo e($quiz->total_mark); ?></h6>
                                <p class="card-text"><?php echo e(__('Minimum Marks')); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-3">
                        <div class="card text-center">
                            <div class="info-col text-center">
                                <img src="<?php echo e(asset('uploads/website-images/test.png')); ?>">
                            </div>
                            <div class="card-body">
                                <h6 class="card-title count"><?php echo e($attempt); ?>/<?php echo e($quiz->attempt); ?></h6>
                                <p class="card-text"><?php echo e(__('Attempts')); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-3">
                        <div class="card text-center">
                            <div class="info-col text-center">
                                <img src="<?php echo e(asset('uploads/website-images/question.png')); ?>">
                            </div>
                            <div class="card-body">
                                <h6 class="card-title count"><?php echo e($quiz->questions_count); ?></h6>
                                <p class="card-text"><?php echo e(__('Questions')); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 mb-3">
                        <div class="card text-center">
                            <div class="info-col text-center">
                                <img src="<?php echo e(asset('uploads/website-images/clock.png')); ?>">
                            </div>
                            <div class="card-body">
                                <h6 class="card-title count"><span
                                        class="hour"><?php echo e(__('0')); ?></span><?php echo e(__(':')); ?><span
                                        class="minute"><?php echo e(__('0')); ?></span><?php echo e(__(':')); ?><span
                                        class="second"><?php echo e(__('0')); ?></span></h6>
                                <p class="card-text"><?php echo e(__('Remained time')); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="alert alert-primary d-flex align-items-center" role="alert">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor"
                    class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16" role="img"
                    aria-label="Warning:">
                    <path
                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                </svg>
                <div>
                    <?php echo e(__('Please note that you have to complete all the questions and submit before remaining time. The form will be submitted automatically if remaining time ends.')); ?>

                </div>
            </div>

            <div class="card mt-3">
                <form action="<?php echo e(route('student.quiz.store', request('id'))); ?>" method="POST" class="question-form">
                    <?php echo csrf_field(); ?>
                    <div class="card-body">
                        <?php $__currentLoopData = $quiz->questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="question-box mt-4">
                                <h6><?php echo e($loop->iteration); ?>. <?php echo e($question->title); ?></h6>
                                <div class="row">
                                    <?php $__currentLoopData = $question->answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6">
                                            <div class="card ans-body m-2">
                                                <label for="ans-<?php echo e($answer->id); ?>" class="box first">
                                                    <div class="course">
                                                        <span class="circle">
                                                            <input type="radio" name="question[<?php echo e($question->id); ?>]"
                                                                id="ans-<?php echo e($answer->id); ?>" value="<?php echo e($answer->id); ?>">
                                                        </span>
                                                        <span class="subject"><?php echo e($answer->title); ?></span>
                                                    </div>
                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <div class="mt-4 text-end">
                            <button class="btn btn-primary" type="submit"><?php echo e(__('Submit')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('frontend/js/default/quiz-page.js')); ?>"></script>
    <script>
        $(document).ready(function() {
            countdown(<?php echo e($quiz->time); ?>);
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('frontend.pages.learning-player.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\pages\learning-player\quiz-index.blade.php ENDPATH**/ ?>