<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Faq Section')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Faq Section')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Faq Section')); ?></div>
                </div>
            </div>
            <div class="section-body row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="service_card"><?php echo e(__('Available Translations')); ?></h5>

                            <hr>
                            <?php if($code !== $languages->first()->code): ?>
                                <button class="btn btn-primary" id="translate-btn"><?php echo e(__('Translate')); ?></button>
                            <?php endif; ?>

                        </div>
                        <div class="card-body">
                            <div class="lang_list_top">
                                <ul class="lang_list">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a id="<?php echo e(request('code') == $language->code ? 'selected-language' : ''); ?>"
                                                href="<?php echo e(route('admin.faq-section.update', ['code' => $language->code])); ?>"><i
                                                    class="fas <?php echo e(request('code') == $language->code ? 'fa-eye' : 'fa-edit'); ?>"></i>
                                                <?php echo e($language->name); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div class="mt-2 alert alert-danger" role="alert">
                                <?php
                                    $current_language = $languages->where('code', request()->get('code'))->first();
                                ?>
                                <p><?php echo e(__('Your editing mode')); ?> :
                                    <b><?php echo e($current_language?->name); ?></b>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Faq Section')); ?></h4>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.faq-section.update', ['code' => $code])); ?>" method="post"
                                    enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>


                                    <div class="col-md-4 <?php echo e($code == $languages->first()->code ? '' : 'd-none'); ?>">
                                        <div class="form-group">
                                           <label><?php echo e(__('Image')); ?> <br><code>(<?php echo e(__('Recommended')); ?>: 370X480 PX)</code></label>
                                            <div id="image-preview" class="image-preview">
                                                <label for="image-upload" id="image-label"><?php echo e(__('Image')); ?></label>
                                                <input type="file" name="image" id="image-upload">
                                            </div>
                                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="short_title"><?php echo e(__('Short Title')); ?><span
                                                    class="text-danger">*</span></label>
                                            <input data-translate="true" type="text" id="short_title" name="short_title"
                                                value="<?php echo e($faqSection->getTranslation($code)?->content?->short_title); ?>"
                                                placeholder="<?php echo e(__('Enter Subtitle')); ?>" class="form-control">
                                            <?php $__errorArgs = ['short_title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="title"><?php echo e(__('Title')); ?><span
                                                    class="text-danger">*</span></label>
                                            <input data-translate="true" type="text" id="title" name="title"
                                                value="<?php echo e($faqSection?->getTranslation($code)?->content?->title); ?>"
                                                placeholder="<?php echo e(__('Enter Title')); ?>" class="form-control">
                                            <small><?php echo e(__('wrap your word with [] for highlight and \ for break and {} for bold')); ?></small>
                                            <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="description"><?php echo e(__('Description')); ?><span
                                                    class="text-danger">*</span></label>
                                            <input data-translate="true" type="text" id="description" name="description"
                                                value="<?php echo e($faqSection?->getTranslation($code)?->content?->description); ?>"
                                                placeholder="<?php echo e(__('Description')); ?>" class="form-control">
                                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="text-center col">
                                        <?php if (isset($component)) { $__componentOriginal42eb0eb0445477e4b420137b90787aa6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42eb0eb0445477e4b420137b90787aa6 = $attributes; } ?>
<?php $component = App\View\Components\Admin\SaveButton::resolve(['text' => __('Save')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.save-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\SaveButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $attributes = $__attributesOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $component = $__componentOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__componentOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <?php if($code == $languages->first()->code): ?>
        <script src="<?php echo e(asset('backend/js/jquery.uploadPreview.min.js')); ?>"></script>
        <script>
            $(document).ready(function() {
                $.uploadPreview({
                    input_field: "#image-upload",
                    preview_box: "#image-preview",
                    label_field: "#image-label",
                    label_default: "<?php echo e(__('Choose Image')); ?>",
                    label_selected: "<?php echo e(__('Change Image')); ?>",
                    no_label: false,
                    success_callback: null
                });

                $('#image-preview').css({
                    'background-image': 'url(<?php echo e(asset($faqSection?->global_content?->image)); ?>)',
                    'background-size': 'contain',
                    'background-position': 'center',
                    'background-repeat': 'no-repeat'
                });
            });
        </script>
    <?php endif; ?>
    <script>
        $(document).ready(function() {
            $('#translate-btn').on('click', function() {
                translateAllTo("<?php echo e($code); ?>");
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Frontend\resources\views\university\faq-section.blade.php ENDPATH**/ ?>