 <?php $__env->startSection('title'); ?>
    <title><?php echo e(__('General Setting')); ?></title>
    <?php $__env->stopSection(); ?> <?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.settings')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('General Setting')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active">
                        <a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active">
                        <a href="<?php echo e(route('admin.settings')); ?>"><?php echo e(__('Settings')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('General Setting')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <ul class="nav nav-pills flex-column" id="generalTab" role="tablist">
                                    <?php echo $__env->make('globalsetting::settings.tabs.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-body">
                                <div class="tab-content" id="myTabContent2">
                                    <?php echo $__env->make('globalsetting::settings.sections.general', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('globalsetting::settings.sections.logo-favicon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('globalsetting::settings.sections.cookie', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('globalsetting::settings.sections.custom-paginate', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('globalsetting::settings.sections.breadcrump', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('globalsetting::settings.sections.copyright', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('globalsetting::settings.sections.maintenance-mode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    <?php echo $__env->make('globalsetting::settings.sections.watermark', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/js/jquery.uploadPreview.min.js')); ?>"></script>
    <script>
        //Tab active setup locally
        $(document).ready(function() {
            "use strict";
            var activeTab = localStorage.getItem("activeTab");
            if (activeTab) {
                $('#generalTab a[href="#' + activeTab + '"]').tab("show");
            } else {
                $("#generalTab a:first").tab("show");
            }

            $('a[data-toggle="tab"]').on("shown.bs.tab", function(e) {
                var newTab = $(e.target).attr("href").substring(1);
                localStorage.setItem("activeTab", newTab);
            });

            $.uploadPreview({
                input_field: "#image-upload-breadcrumb",
                preview_box: "#image-preview-breadcrumb",
                label_field: "#image-label-breadcrumb",
                label_default: "<?php echo e(__('Choose Image')); ?>",
                label_selected: "<?php echo e(__('Change Image')); ?>",
                no_label: false,
                success_callback: null
            });

            $('#image-preview-breadcrumb').css({
                'background-image': 'url(<?php echo e(asset($setting->breadcrumb_image)); ?>)',
                'background-size': 'contain',
                'background-position': 'center',
                'background-repeat': 'no-repeat'
            });

            $.uploadPreview({
                input_field: "#image-maintenance",
                preview_box: "#image-preview-maintenance",
                label_field: "#image-label-maintenance",
                label_default: "<?php echo e(__('Choose Image')); ?>",
                label_selected: "<?php echo e(__('Change Image')); ?>",
                no_label: false,
                success_callback: null
            });

            $('#image-preview-maintenance').css({
                'background-image': 'url(<?php echo e(asset($setting?->maintenance_image)); ?>)',
                'background-size': 'contain',
                'background-position': 'center',
                'background-repeat': 'no-repeat'
            });

            $.uploadPreview({
                input_field: "#image-upload-1",
                preview_box: "#image-preview-1",
                label_field: "#image-label-1",
                label_default: "<?php echo e(__('Choose Image')); ?>",
                label_selected: "<?php echo e(__('Change Image')); ?>",
                no_label: false,
                success_callback: null
            });
            $('#image-preview-1').css({
                'background-image': 'url(<?php echo e(!empty($setting->logo) ? asset($setting->logo) : ''); ?>)',
                'background-size': 'contain',
                'background-position': 'center',
                'background-repeat': 'no-repeat'
            });

            $.uploadPreview({
                input_field: "#image-upload-2",
                preview_box: "#image-preview-2",
                label_field: "#image-label-2",
                label_default: "<?php echo e(__('Choose Image')); ?>",
                label_selected: "<?php echo e(__('Change Image')); ?>",
                no_label: false,
                success_callback: null
            });
            $('#image-preview-2').css({
                'background-image': 'url(<?php echo e(asset(@$setting->favicon)); ?>)',
                'background-size': 'contain',
                'background-position': 'center',
                'background-repeat': 'no-repeat'
            });

            $.uploadPreview({
                input_field: "#image-upload-3",
                preview_box: "#image-preview-3",
                label_field: "#image-label-3",
                label_default: "<?php echo e(__('Choose Image')); ?>",
                label_selected: "<?php echo e(__('Change Image')); ?>",
                no_label: false,
                success_callback: null
            });
            $('#image-preview-3').css({
                'background-image': 'url(<?php echo e(asset(@$setting->preloader)); ?>)',
                'background-size': 'contain',
                'background-position': 'center',
                'background-repeat': 'no-repeat'
            });
            $.uploadPreview({
            input_field: "#image-upload-4",
            preview_box: "#image-preview-4",
            label_field: "#image-label-4",
            label_default: "<?php echo e(__('Choose Image')); ?>",
            label_selected: "<?php echo e(__('Change Image')); ?>",
            no_label: false,
            success_callback: null
        });
        $('#image-preview-4').css({
            'background-image': "url(<?php echo e(asset(@$setting?->watermark_img ?? 'uploads/website-images/watermark.svg')); ?>)",
            'background-size': 'contain',
            'background-position': 'center',
            'background-repeat': 'no-repeat'
        });

        });
        //Maintenance mode toggler
        function changeMaintenanceModeStatus() {
            var isDemo = "<?php echo e(strtoupper(config('app.app_mode')) ?? 'LIVE'); ?>"
            if (isDemo == 'DEMO') {
                toastr.error("<?php echo e(__('This Is Demo Version. You Can Not Change Anything')); ?>");
                return;
            }
            $.ajax({
                type: "put",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                },
                url: "<?php echo e(url('/admin/update-maintenance-mode-status')); ?>",
                success: function(response) {
                    if (response.success) {
                        toastr.success(response.message);
                    } else {
                        toastr.warning(response.message);
                    }
                },
                error: function(err) {
                    console.log(err);

                }
            })
        }
    </script>

    <script>
        function copyText() {
            var textToCopy = document.getElementById("copyCronText");
            var range = document.createRange();
            range.selectNode(textToCopy);
            window.getSelection().removeAllRanges();
            window.getSelection().addRange(range);
            document.execCommand("copy");

            toastr.success("<?php echo e(__('Copied to clipboard')); ?>");
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\GlobalSetting\resources\views\settings\index.blade.php ENDPATH**/ ?>