<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Coupon List')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Coupon List')); ?></h1>
            </div>

            <div class="section-body">
                <div class="text-right">
 <a href="javascript:;" data-toggle="modal" data-target="#create_coupon_id" class="btn btn-primary"><i
                        class="fas fa-plus"></i> <?php echo e(__('Add New')); ?></a>
                </div>
               
                <div class="row mt-sm-4">
                    <div class="col-12">
                        <div class="card ">
                            <div class="card-body">
                                <div class="table-responsive table-invoice">
                                    <table class="table table-striped">
                                        <thead>
                                            <tr>
                                                <th><?php echo e(__('SN')); ?></th>
                                                <th><?php echo e(__('Coupon Code')); ?></th>
                                                <th><?php echo e(__('Min Price')); ?></th>
                                                <th><?php echo e(__('Offer')); ?></th>
                                                <th><?php echo e(__('End time')); ?></th>
                                                <th><?php echo e(__('Status')); ?></th>
                                                <th><?php echo e(__('Action')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e(++$index); ?></td>
                                                    <td><?php echo e($coupon->coupon_code); ?></td>
                                                    <td><?php echo e(currency($coupon->min_price)); ?></td>
                                                    <td><?php echo e($coupon->offer_percentage); ?>%</td>

                                                    <td><?php echo e(date('d M Y', strtotime($coupon->expired_date))); ?></td>

                                                    <td>
                                                        <?php if($coupon->status == 'active'): ?>
                                                            <span class="badge badge-success"><?php echo e(__('Active')); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge badge-danger"><?php echo e(__('Inactive')); ?></span>
                                                        <?php endif; ?>
                                                    </td>

                                                    <td>

                                                        <a href="javascript:;" data-toggle="modal"
                                                            data-target="#edit_coupon_id_<?php echo e($coupon->id); ?>"
                                                            class="btn btn-primary btn-sm"><i class="fa fa-edit"
                                                                aria-hidden="true"></i></a>

                                                        <a href="javascript:;" data-toggle="modal"
                                                            data-target="#deleteModal" class="btn btn-danger btn-sm"
                                                            onclick="deleteData(<?php echo e($coupon->id); ?>)"><i
                                                                class="fa fa-trash" aria-hidden="true"></i></a>

                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __('Coupon'),'route' => '','create' => 'no','message' => __('No data found!'),'colspan' => '7'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <?php $__currentLoopData = $coupons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $coupon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="modal fade" id="edit_coupon_id_<?php echo e($coupon->id); ?>" tabindex="-1" role="dialog"
            aria-labelledby="modelTitleId" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="container-fluid">
                            <form action="<?php echo e(route('admin.coupon.update', $coupon->id)); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="form-group">
                                    <label for=""><?php echo e(__('Coupon Code')); ?> <span
                                            class="text-danger">*</span></label>
                                    <input type="text" name="coupon_code" autocomplete="off" class="form-control"
                                        value="<?php echo e($coupon->coupon_code); ?>">
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo e(__('Minimum purchase price')); ?> <span data-toggle="tooltip"
                                            data-placement="top" class="fa fa-info-circle text--primary"
                                            title="Price should be USD($)"> <span class="text-danger">*</span></label>
                                    <input type="text" name="min_price" autocomplete="off" class="form-control"
                                        value="<?php echo e($coupon->min_price); ?>">
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo e(__('Offer')); ?>(%) <span class="text-danger">*</span></label>
                                    <input type="text" name="offer_percentage" autocomplete="off" class="form-control"
                                        value="<?php echo e($coupon->offer_percentage); ?>">
                                </div>

                                <div class="form-group">
                                    <label for=""><?php echo e(__('End time')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" name="expired_date" autocomplete="off"
                                        class="form-control datepicker" value="<?php echo e($coupon->expired_date); ?>">
                                </div>

                                <div class="form-group">
                                    <label><?php echo e(__('Status')); ?> <span class="text-danger">*</span></label>
                                    <select name="status" id="" class="form-control">
                                        <option <?php echo e($coupon->status == 'active' ? 'selected' : ''); ?> value="active">
                                            <?php echo e(__('Active')); ?></option>
                                        <option <?php echo e($coupon->status == 'inactive' ? 'selected' : ''); ?> value="inactive">
                                            <?php echo e(__('Inactive')); ?></option>
                                    </select>
                                </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-warning" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    <!-- Modal -->
    <div class="modal fade" id="create_coupon_id" tabindex="-1" role="dialog" aria-labelledby="modelTitleId"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="container-fluid">
                        <form action="<?php echo e(route('admin.coupon.store')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label for=""><?php echo e(__('Coupon Code')); ?> <span class="text-danger">*</span></label>
                                <input type="text" name="coupon_code" autocomplete="off" class="form-control">
                            </div>

                            <div class="form-group">
                                <label for=""><?php echo e(__('Minimum purchase price')); ?> <span data-toggle="tooltip"
                                        data-placement="top" class="fa fa-info-circle text--primary"
                                        title="Price should be USD($)"> <span class="text-danger">*</span></label>
                                <input type="text" name="min_price" autocomplete="off" class="form-control">
                            </div>

                            <div class="form-group">
                                <label for=""><?php echo e(__('Offer')); ?>(%) <span class="text-danger">*</span></label>
                                <input type="text" name="offer_percentage" autocomplete="off" class="form-control">
                            </div>



                            <div class="form-group">
                                <label for=""><?php echo e(__('End time')); ?> <span class="text-danger">*</span></label>
                                <input type="text" name="expired_date" autocomplete="off"
                                    class="form-control datepicker">
                            </div>

                            <div class="form-group">
                                <label><?php echo e(__('Status')); ?> <span class="text-danger">*</span></label>
                                <select name="status" id="" class="form-control">
                                    <option value="active"><?php echo e(__('Active')); ?></option>
                                    <option value="inactive"><?php echo e(__('Inactive')); ?></option>
                                </select>
                            </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-warning" data-dismiss="modal"><?php echo e(__('Close')); ?></button>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Save')); ?></button>
                </div>
                </form>
            </div>
        </div>
    </div>


    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
    <script>
        "use strict"

        function deleteData(id) {
            $("#deleteForm").attr("action", '<?php echo e(url('admin/coupon/')); ?>' + "/" + id)
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Coupon\resources\views\index.blade.php ENDPATH**/ ?>