<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap">
        <div class="dashboard__content-title d-flex justify-content-between">
            <h4 class="title"><?php echo e(__('Enrolled Courses')); ?></h4>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="row">
                    <div class="col-12">
                        <div class="tab-content" id="courseTabContent">
                            <?php $__empty_1 = true; $__currentLoopData = $enrolls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enroll): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="tab-pane fade show active" id="all-tab-pane" role="tabpanel"
                                    aria-labelledby="all-tab" tabindex="0">
                                    <div class="dashboard-courses-active dashboard_courses">
                                        <div class="courses__item courses__item-two shine__animate-item">
                                            <div class="row align-items-center">
                                                <div class="col-xl-5">
                                                    <div class="courses__item-thumb courses__item-thumb-two">
                                                        <a href="<?php echo e(route('student.learning.index', $enroll->course->slug)); ?>"
                                                            class="shine__animate-link">
                                                            <img src="<?php echo e(asset($enroll->course->thumbnail)); ?>"
                                                                alt="img">
                                                        </a>
                                                    </div>
                                                </div>
                                                <div class="col-xl-7">
                                                    <div class="courses__item-content courses__item-content-two">
                                                        <ul class="courses__item-meta list-wrap">
                                                            <li class="courses__item-tag">
                                                                <a
                                                                    href="javascript:;"><?php echo e($enroll->course->category->translation->name); ?></a>
                                                            </li>
                                                        </ul>

                                                        <h5 class="title"><a
                                                                href="<?php echo e(route('student.learning.index', $enroll->course->slug)); ?>"><?php echo e($enroll->course->title); ?></a>
                                                        </h5>
                                                        <div class="courses__item-content-bottom">
                                                            <div class="author-two">
                                                                <a href="javascript:;"><img
                                                                        src="<?php echo e(asset($enroll->course->instructor->image)); ?>"
                                                                        alt="img"><?php echo e($enroll->course->instructor->name); ?></a>
                                                            </div>
                                                            <div class="avg-rating">
                                                                <i class="fas fa-star"></i>
                                                                <?php echo e(number_format($enroll->course->reviews()->avg('rating') ?? 0, 1)); ?>

                                                            </div>
                                                        </div>
                                                        <?php
                                                            $courseLectureCount = App\Models\CourseChapterItem::whereHas(
                                                                'chapter',
                                                                function ($q) use ($enroll) {
                                                                    $q->where('course_id', $enroll->course->id);
                                                                },
                                                            )->count();

                                                            $courseLectureCompletedByUser = App\Models\CourseProgress::where(
                                                                'user_id',
                                                                userAuth()->id,
                                                            )
                                                                ->where('course_id', $enroll->course->id)
                                                                ->where('watched', 1)
                                                                ->count();
                                                            $courseCompletedPercent =
                                                                $courseLectureCount > 0
                                                                    ? ($courseLectureCompletedByUser /
                                                                            $courseLectureCount) *
                                                                        100
                                                                    : 0;
                                                        ?>
                                                        <div class="progress-item progress-item-two">
                                                            <h6 class="title">
                                                                <?php echo e(__('COMPLETE')); ?><span><?php echo e(number_format($courseCompletedPercent, 1)); ?>%</span>
                                                            </h6>
                                                            <div class="progress" role="progressbar"
                                                                aria-label="Example with label" aria-valuenow="25"
                                                                aria-valuemin="0" aria-valuemax="100">
                                                                <div class="progress-bar"
                                                                    style="width: <?php echo e(number_format($courseCompletedPercent, 1)); ?>%">
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <div class="courses__item-bottom-two">
                                                        <ul class="list-wrap">
                                                            <li><i class="flaticon-book"></i><?php echo e($courseLectureCount); ?>

                                                            </li>
                                                            <li><i
                                                                    class="flaticon-clock"></i><?php echo e(minutesToHours($enroll->course->duration)); ?>

                                                            </li>
                                                            <li><i
                                                                    class="flaticon-mortarboard"></i><?php echo e($enroll->course->enrollments()->count()); ?>

                                                            </li>
                                                            <?php if($courseCompletedPercent == 100): ?>
                                                                <li class="ms-auto">
                                                                    <a class="basic-button"
                                                                        href="<?php echo e(route('student.download-certificate', $enroll->course->id)); ?>"><i
                                                                            class="certificate fas fa-download"></i>
                                                                        <?php echo e(__('Certificate')); ?></a>
                                                                </li>
                                                            <?php endif; ?>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <h6 class="text-center"><?php echo e(__('No Course Found')); ?></h6>
                            <?php endif; ?>
                        </div>
                        <div class="enroll-courses pagination__wrap mt-25">
                            <?php echo e($enrolls->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.student-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\student-dashboard\enrolled-courses\index.blade.php ENDPATH**/ ?>