<div class="main-sidebar">
    <aside id="sidebar-wrapper">
        <div class="sidebar-brand">
            <a href="<?php echo e(route('admin.dashboard')); ?>"><img class="admin_logo" src="<?php echo e(asset($setting->logo) ?? ''); ?>"
                    alt="<?php echo e($setting->app_name ?? ''); ?>"></a>
        </div>

        <div class="sidebar-brand sidebar-brand-sm">
            <a href="<?php echo e(route('admin.dashboard')); ?>"><img src="<?php echo e(asset($setting->favicon) ?? ''); ?>"
                    alt="<?php echo e($setting->app_name ?? ''); ?>"></a>
        </div>

        <ul class="sidebar-menu">
            <?php if(auth()->guard('admin')->user()->can('dashboard.view')): ?>
                <li class="<?php echo e(Route::is('admin.dashboard') ? 'active' : ''); ?>">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>"><i class="fas fa-home"></i>
                        <span><?php echo e(__('Dashboard')); ?></span>
                    </a>
                </li>
            <?php endif; ?>

            <?php if(Module::isEnabled('GlobalSetting') && checkAdminHasPermission('setting.view')): ?>
                <?php echo $__env->make('globalsetting::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <?php if(checkAdminHasPermission('basic.payment.view')): ?>
                <?php if(Module::isEnabled('BasicPayment') && checkAdminHasPermission('basic.payment.view')): ?>
                    <?php echo $__env->make('basicpayment::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php endif; ?>
            <?php endif; ?>

            <?php if(auth()->guard('admin')->user()->can('currency.view')): ?>
                <?php echo $__env->make('currency::sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>

            <?php if(checkAdminHasPermission('admin.view') || checkAdminHasPermission('role.view')): ?>
                <li class="menu-header"><?php echo e(__('Administration Settings')); ?></li>
                <li
                    class="nav-item dropdown <?php echo e(Route::is('admin.admin.*') || Route::is('admin.role.*') ? 'active' : ''); ?>">
                    <a href="#" class="nav-link has-dropdown"><i
                            class="fas fa-shield-alt"></i><span><?php echo e(__('Admin & Roles')); ?></span></a>
                    <ul class="dropdown-menu">
                        <?php if(auth()->guard('admin')->user()->can('admin.view')): ?>
                            <li class="<?php echo e(Route::is('admin.admin.*') ? 'active' : ''); ?>">
                                <a class="nav-link" href="<?php echo e(route('admin.admin.index')); ?>"><?php echo e(__('Manage Admin')); ?></a>
                            </li>
                        <?php endif; ?>
                        <?php if(auth()->guard('admin')->user()->can('role.view')): ?>
                            <li class="<?php echo e(Route::is('admin.role.*') ? 'active' : ''); ?>">
                                <a class="nav-link"
                                    href="<?php echo e(route('admin.role.index')); ?>"><?php echo e(__('Role & Permissions')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>
        </ul>
    </aside>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\admin\settings\sidebar.blade.php ENDPATH**/ ?>