<?php $__env->startSection('title'); ?>
    <title><?php echo e($title); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e($title); ?></h1>
            </div>

            <div class="section-body">
                <div class="row">
                    
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.orders')); ?>" method="GET" onchange="$(this).trigger('submit')"
                                    class="form_padding">
                                    <div class="row">
                                        <div class="col-md-4 form-group">
                                            <input type="text" name="keyword" value="<?php echo e(request()->get('keyword')); ?>"
                                                class="form-control" placeholder="<?php echo e(__('Search')); ?>">
                                        </div>

                                        <div class="col-md-2 form-group">
                                            <select name="order_status" class="form-control">
                                                <option value=""><?php echo e(__('Order status')); ?></option>
                                                <option value="pending"
                                                    <?php echo e(request('order_status') == 'pending' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Pending')); ?>

                                                </option>
                                                <option value="processing"
                                                    <?php echo e(request('order_status') == 'processing' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Processing')); ?>

                                                </option>
                                                <option value="completed"
                                                    <?php echo e(request('order_status') == 'completed' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Completed')); ?>

                                                </option>
                                                <option value="declined"
                                                    <?php echo e(request('order_status') == 'declined' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Declined')); ?>

                                                </option>
                                            </select>
                                        </div>

                                        <div class="col-md-2 form-group">
                                            <select name="payment_status" id="status" class="form-control">
                                                <option value=""><?php echo e(__('Payment Status')); ?></option>
                                                <option value="pending"
                                                    <?php echo e(request('payment_status') == 'pending' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Pending')); ?>

                                                </option>
                                                <option value="paid"
                                                    <?php echo e(request('payment_status') == 'paid' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Paid')); ?>

                                                </option>
                                                <option value="cancelled"
                                                    <?php echo e(request('payment_status') == 'cancelled' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('Cancelled')); ?>

                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-2 form-group">
                                            <select name="order_by" id="order_by" class="form-control">
                                                <option value=""><?php echo e(__('Order By')); ?></option>
                                                <option value="1" <?php echo e(request('order_by') == '1' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('ASC')); ?>

                                                </option>
                                                <option value="0" <?php echo e(request('order_by') == '0' ? 'selected' : ''); ?>>
                                                    <?php echo e(__('DESC')); ?>

                                                </option>
                                            </select>
                                        </div>
                                        <div class="col-md-2 form-group">
                                            <select name="par-page" id="par-page" class="form-control">
                                                <option value=""><?php echo e(__('Per Page')); ?></option>
                                                <option value="10" <?php echo e('10' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('10')); ?>

                                                </option>
                                                <option value="50" <?php echo e('50' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('50')); ?>

                                                </option>
                                                <option value="100"
                                                    <?php echo e('100' == request('par-page') ? 'selected' : ''); ?>>
                                                    <?php echo e(__('100')); ?>

                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 col-md-12 col-lg-12">
                        <div class="card">
                            <div class="card-body text-center">
                                <div class="table-responsive">
                                    <table class="table table-striped">
                                        <tr>
                                            <th><?php echo e(__('SN')); ?></th>
                                            <th><?php echo e(__('User')); ?></th>
                                            <th><?php echo e(__('Order Id')); ?></th>
                                            <th><?php echo e(__('Paid Amount')); ?></th>
                                            <th><?php echo e(__('Gateway')); ?></th>
                                            <th><?php echo e(__('Status')); ?></th>
                                            <th><?php echo e(__('Payment')); ?></th>
                                            <th><?php echo e(__('Action')); ?></th>
                                        </tr>

                                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td><?php echo e(++$index); ?></td>
                                                <td><a
                                                        href="<?php echo e(route('admin.customer-show', $order->buyer_id)); ?>"><?php echo e($order?->user?->name); ?></a>
                                                </td>
                                                <td>#<?php echo e($order->invoice_id); ?></td>
                                                <td><?php echo e($order->paid_amount); ?> <?php echo e($order->payable_currency); ?></td>
                                                <td>
                                                    <?php echo e($order->payment_method); ?>

                                                </td>
                                                <td>
                                                    <?php if($order->status == 'completed'): ?>
                                                        <div class="badge badge-success"><?php echo e(__('Completed')); ?></div>
                                                    <?php elseif($order->status == 'processing'): ?>
                                                        <div class="badge badge-warning"><?php echo e(__('Processing')); ?></div>
                                                    <?php elseif($order->status == 'declined'): ?>
                                                        <div class="badge badge-danger"><?php echo e(__('Declined')); ?></div>
                                                    <?php else: ?>
                                                        <div class="badge badge-warning"><?php echo e(__('Pending')); ?></div>
                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <?php if($order->payment_status == 'paid'): ?>
                                                        <div class="badge badge-success"><?php echo e(__('Paid')); ?></div>
                                                    <?php elseif($order->payment_status == 'cancelled'): ?>
                                                        <div class="badge badge-danger"><?php echo e(__('Cancelled')); ?></div>
                                                    <?php else: ?>
                                                        <div class="badge badge-danger"><?php echo e(__('Pending')); ?></div>
                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <a href="<?php echo e(route('admin.order', $order->id)); ?>"
                                                        class="btn btn-primary btn-sm"><i class="fa fa-eye"></i></a>

                                                    <a href="javascript:;" data-toggle="modal" data-target="#deleteModal"
                                                        class="btn btn-danger btn-sm"
                                                        onclick="deleteData(<?php echo e($order->id); ?>)"><i class="fa fa-trash"
                                                            aria-hidden="true"></i></a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <?php if (isset($component)) { $__componentOriginal875c7a0bb47165de86ff51577f723b01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal875c7a0bb47165de86ff51577f723b01 = $attributes; } ?>
<?php $component = App\View\Components\EmptyTable::resolve(['name' => __('Orders'),'route' => '','create' => 'no','message' => __('No data found!'),'colspan' => '9'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('empty-table'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\EmptyTable::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $attributes = $__attributesOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__attributesOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal875c7a0bb47165de86ff51577f723b01)): ?>
<?php $component = $__componentOriginal875c7a0bb47165de86ff51577f723b01; ?>
<?php unset($__componentOriginal875c7a0bb47165de86ff51577f723b01); ?>
<?php endif; ?>
                                        <?php endif; ?>
                                    </table>
                                </div>
                                <div class="d-flex justify-content-end">
                                    <?php echo e($orders->links()); ?>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>


    <?php if (isset($component)) { $__componentOriginalaa3b824e4662c5ae30529397669d1c1d = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.delete-modal','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.delete-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $attributes = $__attributesOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__attributesOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d)): ?>
<?php $component = $__componentOriginalaa3b824e4662c5ae30529397669d1c1d; ?>
<?php unset($__componentOriginalaa3b824e4662c5ae30529397669d1c1d); ?>
<?php endif; ?>

    <script>
        'use strict'

        function deleteData(id) {
            $("#deleteForm").attr("action", "<?php echo e(url('admin/order-delete/')); ?>" + "/" + id)
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Order\resources\views\index.blade.php ENDPATH**/ ?>