<div class="modal-header">
    <h1 class="modal-title fs-5" id=""><?php echo e(__('Add Lesson')); ?></h1>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>

<div class="p-3">
    <form action="<?php echo e(route('instructor.course-chapter.lesson.store')); ?>" method="POST"
        class="add_lesson_form instructor__profile-form">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="course_id" value="<?php echo e($courseId); ?>">
        <input type="hidden" name="chapter_id" value="<?php echo e($chapterId); ?>">
        <input type="hidden" name="type" value="<?php echo e($type); ?>">

        <div class="col-md-12">
            <div class="form-grp">
                <label for="chapter"><?php echo e(__('Chapter')); ?> <code>*</code></label>
                <select name="chapter" id="chapter" class="chapter from-select">
                    <option value=""><?php echo e(__('Select')); ?></option>
                    <?php $__currentLoopData = $chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php if($chapterId == $chapter->id): echo 'selected'; endif; ?> value="<?php echo e($chapter->id); ?>"><?php echo e($chapter->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-grp">
                <label for="title"><?php echo e(__('Title')); ?> <code>*</code></label>
                <input id="title" name="title" type="text" value="">
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="form-grp">
                    <label for="source"><?php echo e(__('Source')); ?> <code>*</code></label>
                    <select name="source" id="source" class="source form-select">
                        <option value=""><?php echo e(__('Select')); ?></option>
                        <?php if($setting?->aws_status == 'active'): ?>
                            <option value="aws"><?php echo e(config('course.storage_source.aws')); ?></option>
                        <?php endif; ?>
                        <?php $__currentLoopData = config('course.storage_source'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($key != 'aws' && $key != 'wasabi'): ?>
                                <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php if($setting?->wasabi_status == 'active'): ?>
                            <option value="wasabi"><?php echo e(config('course.storage_source.wasabi')); ?></option>
                        <?php endif; ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-grp">
                    <label for="file_type"><?php echo e(__('File Type')); ?> <code>*</code></label>
                    <select name="file_type" id="file_type" class="file_type form-select">
                        <option value=""><?php echo e(__('Select')); ?></option>
                        <?php $__currentLoopData = config('course.file_types'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(in_array($key, ['video', 'file', 'other'])): ?>
                                <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="col-md-9 upload">
                <div class="from-group mb-3">
                    <label class="form-file-manager-label" for=""><?php echo e(__('Path')); ?>

                        <code>*</code></label>
                    <div class="input-group">
                        <span class="input-group-text" id="basic-addon1">
                            <a data-input="path" data-preview="holder" class="file-manager">
                                <i class="fa fa-picture-o"></i> <?php echo e(__('Choose')); ?>

                            </a>
                        </span>
                        <input id="path" readonly class="form-control file-manager-input" type="text"
                            name="upload_path" value="">
                    </div>
                </div>
            </div>
            <div class="col-md-12 cloud_storage d-none">
                <div class="form-grp mb-3">
                    <label class="form-file-manager-label" for=""><?php echo e(__('Upload')); ?></label>
                    <div class="input-group">
                        <div class="input-group">
                            <input id="file-input" type="file" class="form-control">
                            <button type="button" id="cloud-btn" class="input-group-text" id="basic-addon1"><i class="fas fa-upload"></i></button>
                        </div>
                    </div>
                    <div class="progress d-none">
                        <div class="progress-bar progress-bar-striped progress-bar-animated w-100" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100"></div>
                    </div>
                </div>
            </div>
            <div class="col-md-9 link_path d-none">
                <div class="form-grp">
                    <label for="meta_description"><?php echo e(__('Path')); ?> <code>*</code></label>
                    <div class="input-group mb-3">
                        <span class="input-group-text" id="basic-addon1"><i class="fas fa-link"></i></span>
                        <input type="text" class="form-control" id="input_link" name="link_path"
                            placeholder="<?php echo e(__('paste source url')); ?>" value="">
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-grp">
                    <label for="duration"><?php echo e(__('Duration')); ?> <code>* (<?php echo e(__('in minutes')); ?>)</code></label>
                    <input id="duration" name="duration" type="text" value="">
                </div>
            </div>
        </div>
        <div class="row is_free_wrapper">
            <div class="col-md-6 mt-2 mb-3">
                <span class="toggle-label"><?php echo e(__('Preview')); ?></span>
                <div class="switcher">
                    <label for="toggle-0">
                        <input type="checkbox" id="toggle-0" value="1" name="is_free" />
                        <span><small></small></span>
                    </label>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-grp">
                <label for="description"><?php echo e(__('Description')); ?> <code></code></label>
                <textarea name="description" class="form-control"></textarea>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary submit-btn"><?php echo e(__('Create')); ?></button>
        </div>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\course\partials\lesson-create-modal.blade.php ENDPATH**/ ?>