<div class="modal-header">
    <h1 class="modal-title fs-5" id=""><?php echo e(__('Add live lesson')); ?></h1>
    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
</div>

<div class="p-3">
    <form action="<?php echo e(route('instructor.course-chapter.lesson.store')); ?>" method="POST"
        class="add_lesson_form instructor__profile-form">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="course_id" value="<?php echo e($courseId); ?>">
        <input type="hidden" name="chapter_id" value="<?php echo e($chapterId); ?>">
        <input type="hidden" name="type" value="<?php echo e($type); ?>">

        <div class="col-md-12">
            <div class="form-grp">
                <label for="chapter"><?php echo e(__('Chapter')); ?> <code>*</code></label>
                <select name="chapter" id="chapter" class="chapter from-select">
                    <option value=""><?php echo e(__('Select')); ?></option>
                    <?php $__currentLoopData = $chapters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chapter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option <?php if($chapterId == $chapter->id): echo 'selected'; endif; ?> value="<?php echo e($chapter->id); ?>"><?php echo e($chapter->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-grp">
                <label for="title"><?php echo e(__('Title')); ?> <code>*</code></label>
                <input id="title" name="title" type="text" value="">
            </div>
        </div>
        <div class="row">
            <div class="col-md-3">
                <div class="form-grp">
                    <label for="live_type"><?php echo e(__('Live Platform')); ?> <code>*</code></label>
                    <select name="live_type" id="live_type" class="form-select">
                        <?php $__currentLoopData = config('course.live_types'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-grp">
                    <label for="start_time"><?php echo e(__('Start Time')); ?> <code>*</code></label>
                    <input id="start_time" name="start_time" type="datetime-local">
                </div>
            </div>

            <div class="col-md-3">
                <div class="form-grp">
                    <label for="duration"><?php echo e(__('Duration')); ?> <code>* (<?php echo e(__('in minutes')); ?>)</code></label>
                    <input id="duration" name="duration" type="text" value="">
                </div>
            </div>
        </div>
        <div class="col-12 zoom-alert-box">
            <div class="alert alert-warning" role="alert">
                <?php echo e(__('The meeting ID, password, and Zoom settings must be configured using the same Zoom account. The course creator needs to set up the')); ?> <a
                    href="<?php echo e(route('instructor.zoom-setting.index')); ?>"><?php echo e(__('Zoom live setting')); ?></a>.
            </div>
        </div>
        <div class="col-12 jitsi-alert-box d-none">
            <div class="alert alert-warning" role="alert">
                <?php echo e(__('The meeting ID and Jitsi settings must be configured. The course creator needs to set up the')); ?> <a
                    href="<?php echo e(route('instructor.jitsi-setting.index')); ?>"><?php echo e(__('Jitsi setting')); ?></a>.
            </div>
        </div>
        <div class="row">
            <div class="col-md-6 meeting-id-box">
                <div class="form-grp">
                    <label for="meeting_id"><?php echo e(__('Meeting ID')); ?> <code>*</code></label>
                    <input id="meeting_id" name="meeting_id" type="text" value="">
                </div>
            </div>
            <div class="col-md-6 zoom-box">
                <div class="form-grp">
                    <label for="password"><?php echo e(__('Password')); ?> <code>*</code></label>
                    <input id="password" name="password" type="text" value="">
                </div>
            </div>
            <div class="col-md-12 zoom-box">
                <div class="form-grp">
                    <label for="join_url"><?php echo e(__('Join URL')); ?></label>
                    <input id="join_url" name="join_url" type="url">
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-grp">
                <label for="description"><?php echo e(__('Description')); ?> <code></code></label>
                <textarea name="description" class="form-control"></textarea>
            </div>
        </div>
        <div class="col-md-12 mb-3">
            <div class="account__check-remember">
                <input id="student_mail_sent" type="checkbox" class="form-check-input" name="student_mail_sent">
                <label for="student_mail_sent" class="form-check-label"><?php echo e(__('Email to all students.')); ?></label>
            </div>
        </div>
        <div class="modal-footer">
            <button type="submit" class="btn btn-primary submit-btn"><?php echo e(__('Create')); ?></button>
        </div>
    </form>
</div>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\course\partials\live-create-modal.blade.php ENDPATH**/ ?>