<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Our Features Section')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Our Features Section')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Our Features Section')); ?></div>
                </div>
            </div>
            <div class="section-body row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="service_card"><?php echo e(__('Available Translations')); ?></h5>

                            <hr>
                            <?php if($code !== $languages->first()->code): ?>
                                <button class="btn btn-primary" id="translate-btn"><?php echo e(__('Translate')); ?></button>
                            <?php endif; ?>

                        </div>
                        <div class="card-body">
                            <div class="lang_list_top">
                                <ul class="lang_list">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a id="<?php echo e(request('code') == $language->code ? 'selected-language' : ''); ?>"
                                                href="<?php echo e(route('admin.our-features-section.index', ['code' => $language->code])); ?>"><i
                                                    class="fas <?php echo e(request('code') == $language->code ? 'fa-eye' : 'fa-edit'); ?>"></i>
                                                <?php echo e($language->name); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div class="mt-2 alert alert-danger" role="alert">
                                <?php
                                    $current_language = $languages->where('code', request()->get('code'))->first();
                                ?>
                                <p><?php echo e(__('Your editing mode')); ?> :
                                    <b><?php echo e($current_language?->name); ?></b>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Our Features Section')); ?></h4>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.our-features-section.update', ['code' => $code])); ?>"
                                    method="post" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="row">
                                        <div class="col-md-2 <?php echo e($code == $languages->first()->code ? '' : 'd-none'); ?>">
                                            <div class="form-group">
                                                <label><?php echo e(__('Image One')); ?> <br><code>(<?php echo e(__('Recommended')); ?>: 70X70 PX)</code></label>
                                                <div id="image-preview-one" class="image-preview">
                                                    <label for="image-upload"
                                                        id="image-label-one"><?php echo e(__('Image')); ?></label>
                                                    <input type="file" name="image_one" id="image-upload-one">
                                                </div>
                                                <?php $__errorArgs = ['image_one'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-10">
                                            <div class="form-group">
                                                <label><?php echo e(__('Title One')); ?><span class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="title" name="title_one"
                                                    value="<?php echo e($ourFeature?->getTranslation($code)?->content?->title_one); ?>"
                                                    placeholder="<?php echo e(__('Enter Title')); ?>" class="form-control">
                                                <?php $__errorArgs = ['title_one'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Sub Title One')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="sub_title"
                                                    name="sub_title_one"
                                                    value="<?php echo e($ourFeature?->getTranslation($code)?->content?->sub_title_one); ?>"
                                                    placeholder="<?php echo e(__('Enter Sub Title')); ?>" class="form-control">
                                                <?php $__errorArgs = ['sub_title_one'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="row">
                                        <div class="col-md-2 <?php echo e($code == $languages->first()->code ? '' : 'd-none'); ?>">
                                            <div class="form-group">
                                                <label><?php echo e(__('Image Two')); ?> <br><code>(<?php echo e(__('Recommended')); ?>: 70X70 PX)</code></label>
                                                <div id="image-preview-two" class="image-preview">
                                                    <label for="image-upload"
                                                        id="image-label-two"><?php echo e(__('Image')); ?></label>
                                                    <input type="file" name="image_two" id="image-upload-two">
                                                </div>
                                                <?php $__errorArgs = ['image_two'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-10">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Title Two')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="title" name="title_two"
                                                    value="<?php echo e($ourFeature?->getTranslation($code)?->content?->title_two); ?>"
                                                    placeholder="<?php echo e(__('Enter Title')); ?>" class="form-control">
                                                <?php $__errorArgs = ['title_two'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Sub Title Two')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="sub_title_two"
                                                    name="sub_title_two"
                                                    value="<?php echo e($ourFeature?->getTranslation($code)?->content?->sub_title_two); ?>"
                                                    placeholder="<?php echo e(__('Enter Sub Title')); ?>" class="form-control">
                                                <?php $__errorArgs = ['sub_title_two'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="row">
                                        <div class="col-md-2 <?php echo e($code == $languages->first()->code ? '' : 'd-none'); ?>">
                                            <div class="form-group">
                                                <label><?php echo e(__('Image Three')); ?> <br><code>(<?php echo e(__('Recommended')); ?>: 70X70 PX)</code></label>
                                                <div id="image-preview-three" class="image-preview">
                                                    <label for="image-upload"
                                                        id="image-label-three"><?php echo e(__('Image')); ?></label>
                                                    <input type="file" name="image_three" id="image-upload-three">
                                                </div>
                                                <?php $__errorArgs = ['image_three'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-10">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Title Three')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="title"
                                                    name="title_three"
                                                    value="<?php echo e($ourFeature?->getTranslation($code)?->content?->title_three); ?>"
                                                    placeholder="<?php echo e(__('Enter Title Three')); ?>" class="form-control">
                                                <?php $__errorArgs = ['title_three'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Sub Title Three')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="sub_title_three"
                                                    name="sub_title_three"
                                                    value="<?php echo e($ourFeature?->getTranslation($code)?->content?->sub_title_three); ?>"
                                                    placeholder="<?php echo e(__('Enter Sub Title')); ?>" class="form-control">
                                                <?php $__errorArgs = ['sub_title_three'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="row">
                                        <div class="col-md-2 <?php echo e($code == $languages->first()->code ? '' : 'd-none'); ?>">
                                            <div class="form-group">
                                                <label><?php echo e(__('Image Four')); ?> <br><code>(<?php echo e(__('Recommended')); ?>: 70X70 PX)</code></label>
                                                <div id="image-preview-four" class="image-preview">
                                                    <label for="image-upload"
                                                        id="image-label-four"><?php echo e(__('Image')); ?></label>
                                                    <input type="file" name="image_four" id="image-upload-four">
                                                </div>
                                                <?php $__errorArgs = ['image_four'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                        <div class="col-md-10">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Title Four')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="title"
                                                    name="title_four"
                                                    value="<?php echo e($ourFeature?->getTranslation($code)?->content?->title_four); ?>"
                                                    placeholder="<?php echo e(__('Enter Title Four')); ?>" class="form-control">
                                                <?php $__errorArgs = ['title_four'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Sub Title four')); ?><span
                                                        class="text-danger">*</span></label>
                                                <input data-translate="true" type="text" id="sub_title"
                                                    name="sub_title_four"
                                                    value="<?php echo e($ourFeature?->getTranslation($code)?->content?->sub_title_four); ?>"
                                                    placeholder="<?php echo e(__('Enter Sub Title')); ?>" class="form-control">
                                                <?php $__errorArgs = ['sub_title_four'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>

                                    </div>


                                    <div class="text-center col">
                                        <?php if (isset($component)) { $__componentOriginal42eb0eb0445477e4b420137b90787aa6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal42eb0eb0445477e4b420137b90787aa6 = $attributes; } ?>
<?php $component = App\View\Components\Admin\SaveButton::resolve(['text' => __('Save')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.save-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\SaveButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $attributes = $__attributesOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__attributesOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal42eb0eb0445477e4b420137b90787aa6)): ?>
<?php $component = $__componentOriginal42eb0eb0445477e4b420137b90787aa6; ?>
<?php unset($__componentOriginal42eb0eb0445477e4b420137b90787aa6); ?>
<?php endif; ?>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <?php if($code == $languages->first()->code): ?>
        <script src="<?php echo e(asset('backend/js/jquery.uploadPreview.min.js')); ?>"></script>
        <script>
            $(document).ready(function() {
                $.uploadPreview({
                    input_field: "#image-upload-one",
                    preview_box: "#image-preview-one",
                    label_field: "#image-label-one",
                    label_default: "<?php echo e(__('Choose Icon')); ?>",
                    label_selected: "<?php echo e(__('Change Icon')); ?>",
                    no_label: false,
                    success_callback: null
                });

                $('#image-preview-one').css({
                    'background-image': 'url(<?php echo e(asset($ourFeature?->global_content?->image_one)); ?>)',
                    'background-size': 'contain',
                    'background-position': 'center',
                    'background-repeat': 'no-repeat'
                });

                $.uploadPreview({
                    input_field: "#image-upload-two",
                    preview_box: "#image-preview-two",
                    label_field: "#image-label-two",
                    label_default: "<?php echo e(__('Choose Icon')); ?>",
                    label_selected: "<?php echo e(__('Change Icon')); ?>",
                    no_label: false,
                    success_callback: null
                });

                $('#image-preview-two').css({
                    'background-image': 'url(<?php echo e(asset($ourFeature?->global_content?->image_two)); ?>)',
                    'background-size': 'contain',
                    'background-position': 'center',
                    'background-repeat': 'no-repeat'
                });

                $.uploadPreview({
                    input_field: "#image-upload-three",
                    preview_box: "#image-preview-three",
                    label_field: "#image-label-three",
                    label_default: "<?php echo e(__('Choose Icon')); ?>",
                    label_selected: "<?php echo e(__('Change Icon')); ?>",
                    no_label: false,
                    success_callback: null
                });

                $('#image-preview-three').css({
                    'background-image': 'url(<?php echo e(asset($ourFeature?->global_content?->image_three)); ?>)',
                    'background-size': 'contain',
                    'background-position': 'center',
                    'background-repeat': 'no-repeat'
                });

                $.uploadPreview({
                    input_field: "#image-upload-four",
                    preview_box: "#image-preview-four",
                    label_field: "#image-label-four",
                    label_default: "<?php echo e(__('Choose Icon')); ?>",
                    label_selected: "<?php echo e(__('Change Icon')); ?>",
                    no_label: false,
                    success_callback: null
                });

                $('#image-preview-four').css({
                    'background-image': 'url(<?php echo e(asset($ourFeature?->global_content?->image_four)); ?>)',
                    'background-size': 'contain',
                    'background-position': 'center',
                    'background-repeat': 'no-repeat'
                });
            });
        </script>
    <?php endif; ?>
    <script>
        $(document).ready(function() {
            $('#translate-btn').on('click', function() {
                translateAllTo("<?php echo e($code); ?>");
            })
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Frontend\resources\views\business\our-features-section.blade.php ENDPATH**/ ?>