
<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Course Create')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
     <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1 class="text-primary"><?php echo e(__('Certificate')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Certificate')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="dashboard__content-wrap">
                    <div class="row">
                        <div class="col-12">
                            

                            <div class="card">
                                <div class="card-body">
                                    <div class="instructor__profile-form-wrap mt-4">
                                        <form action="<?php echo e(route('admin.verfications.store', ['id' => @$verification->id])); ?>"
                                            class="instructor__profile-form course-form">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="step" value="1">
                                            <input type="hidden" name="next_step" value="2">
                                            <input type="hidden" name="edit_mode"
                                                value="<?php echo e(isset($editMode) && $editMode == true ? true : false); ?>">

                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label for="instructor"><?php echo e(__('Instructor')); ?>

                                                            <code>*</code></label>
                                                        <select name="instructor" id=""
                                                            class="form-control select2">
                                                            <option value=""><?php echo e(__('Select')); ?></option>

                                                        </select>
                                                    </div>
                                                </div>

                                                
        <div class="col-md-6">
            <div class="form-group">
                <label for="student_name"><?php echo e(__('Student Name')); ?> <code>*</code></label>
                <input id="student_name" name="student_name" type="text" class="form-control"
                       value="<?php echo e(old('student_name', @$verification?->student_name)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="father_name"><?php echo e(__('Father Name')); ?> <code>*</code></label>
                <input id="father_name" name="father_name" type="text" class="form-control"
                       value="<?php echo e(old('father_name', @$verification?->father_name)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="cnic_number"><?php echo e(__('CNIC Number')); ?> <code>*</code></label>
                <input id="cnic_number" name="cnic_number" type="text" class="form-control"
                       value="<?php echo e(old('cnic_number', @$verification?->cnic_number)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="date_of_birth"><?php echo e(__('Date of Birth')); ?> <code>*</code></label>
                <input id="date_of_birth" name="date_of_birth" type="date" class="form-control"
                       value="<?php echo e(old('date_of_birth', @$verification?->date_of_birth)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="grade"><?php echo e(__('Grade')); ?> <code>*</code></label>
                <input id="grade" name="grade" type="text" class="form-control"
                       value="<?php echo e(old('grade', @$verification?->grade)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="percentage"><?php echo e(__('Percentage')); ?> <code>*</code></label>
                <input id="percentage" name="percentage" type="number" step="0.01" max="100" min="0"
                       class="form-control" value="<?php echo e(old('percentage', @$verification?->percentage)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="session"><?php echo e(__('Session')); ?> <code>*</code></label>
                <input id="session" name="session" type="text" class="form-control"
                       value="<?php echo e(old('session', @$verification?->session)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="college"><?php echo e(__('College')); ?> <code>*</code></label>
                <input id="college" name="college" type="text" class="form-control"
                       value="<?php echo e(old('college', @$verification?->college)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="diploma_title"><?php echo e(__('Diploma Title')); ?> <code>*</code></label>
                <input id="diploma_title" name="diploma_title" type="text" class="form-control"
                       value="<?php echo e(old('diploma_title', @$verification?->diploma_title)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="diploma_tenure"><?php echo e(__('Diploma Tenure')); ?> <code>*</code></label>
                <input id="diploma_tenure" name="diploma_tenure" type="text" class="form-control"
                       value="<?php echo e(old('diploma_tenure', @$verification?->diploma_tenure)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="result_announcement_date"><?php echo e(__('Result Announcement Date')); ?> <code>*</code></label>
                <input id="result_announcement_date" name="result_announcement_date" type="date" class="form-control"
                       value="<?php echo e(old('result_announcement_date', @$verification?->result_announcement_date)); ?>">
            </div>
        </div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="registration_number"><?php echo e(__('Registration Number')); ?> <code>*</code></label>
                <input id="registration_number" name="registration_number" type="text" class="form-control"
                       value="<?php echo e(old('registration_number', @$verification?->registration_number)); ?>">
            </div>
        </div>

        
<div class="col-md-6">
    <div class="form-group">
        <label for="certificate_number"><?php echo e(__('Certificate Number')); ?> <code>*</code></label>
        <input id="certificate_number" name="certificate_number" type="text" class="form-control"
               value="<?php echo e(old('certificate_number', @$verification?->certificate_number)); ?>">
    </div>
</div>

        
        <div class="col-md-6">
            <div class="form-group">
                <label for="status"><?php echo e(__('Status')); ?> <code>*</code></label>
                <select name="status" class="form-control">
                    <option value="active" <?php if(@$verification?->status == 'active'): echo 'selected'; endif; ?>><?php echo e(__('Active')); ?></option>
                    <option value="canceled" <?php if(@$verification?->status == 'canceled'): echo 'selected'; endif; ?>><?php echo e(__('Canceled')); ?></option>
                    <option value="expired" <?php if(@$verification?->status == 'expired'): echo 'selected'; endif; ?>><?php echo e(__('Expired')); ?></option>
                </select>
            </div>
        </div>
                                            </div>
                                            <button class="btn btn-primary" type="submit"><?php echo e(__('Save')); ?></button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/js/default/courses.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css'); ?>
    <style>
        .dd-custom-css {
            position: absolute;
            will-change: transform;
            top: 0px;
            left: 0px;
            transform: translate3d(0px, -131px, 0px);
        }

        .max-h-400 {
            min-height: 400px;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules/Verification\resources/views/verification/create.blade.php ENDPATH**/ ?>