<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap dashboard__content-wrap-two">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('Earnings')); ?></h4>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="alert alert-primary d-flex align-items-center" role="alert">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16" role="img" aria-label="Warning:">
                      <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
                    </svg>
                    <div>
                      <?php echo e(__('You can change your payment method informations from your profile settings.')); ?>

                    </div>
                  </div>
            </div>
              
            <div class="col-lg-4 col-md-4 col-sm-6">
                <div class="dashboard__counter-item">
                    <div class="icon">
                        <i class="flaticon-mortarboard"></i>
                    </div>
                    <div class="content">
                        <span class="count" data-count=""><?php echo e(currency(userAuth()->wallet_balance)); ?></span>
                        <p><?php echo e(__('Current Balance')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6">
                <div class="dashboard__counter-item">
                    <div class="icon">
                        <i class="flaticon-mortarboard"></i>
                    </div>
                    <div class="content">
                        <span class="count"><?php echo e($totalCourseSold); ?></span>
                        <p><?php echo e(__('Courses Sold')); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-4 col-sm-6">
                <div class="dashboard__counter-item">
                    <div class="icon">
                        <i class="flaticon-mortarboard"></i>
                    </div>
                    <div class="content">
                        <span class="count"><?php echo e(currency($totalWithdraw)); ?></span>
                        <p><?php echo e(__('Total Payout')); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="dashboard__content-wrap dashboard__content-wrap-two mt-3">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('Create a Request')); ?></h4>
        </div>
        <form action="<?php echo e(route('instructor.payout.store')); ?>" method="POST" class="instructor__profile-form">
            <?php echo csrf_field(); ?>
            <table class="table table-bordered">
                <tr>
                    <td><?php echo e(__('Default Gateway')); ?></td>
                    <td><?php echo e($gateway->payout_account); ?></td>
                </tr>
                <tr>
                    <td><?php echo e(__('Minimum Payout')); ?></td>
                    <td><?php echo e(currency($withdrawMethod->min_amount)); ?></td>
                </tr>

                <tr>
                    <td><?php echo e(__('Maximum Payout')); ?></td>
                    <td><?php echo e(currency($withdrawMethod->max_amount)); ?></td>
                </tr>
                <tr>
                    <td><?php echo e(__('Gateway Information')); ?></td>
                    <td>
                        <?php echo nl2br(clean($gateway->payout_information)); ?>

                    </td>
                </tr>
            </table>
            <div class="row">
                <div class="col-md-12">
                    <div class="form-grp">
                        <label for="phone"><?php echo e(__('Withdraw Amount')); ?></label>
                        <input id="phone" name="amount" type="text" value="<?php echo e(old('amount')); ?>">
                    </div>
                </div>
            </div>
            <div class="mb-4">
                <button type="submit" class="btn"><?php echo e(__('Request Payout')); ?></button>
            </div>
        </form>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.instructor-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\instructor-dashboard\payout\create.blade.php ENDPATH**/ ?>