<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Manage Language')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <div class="section-header-back">
                    <a href="<?php echo e(route('admin.languages.index')); ?>" class="btn btn-icon"><i class="fas fa-arrow-left"></i></a>
                </div>
                <h1><?php echo e(__('Manage Language')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a
                            href="<?php echo e(route('admin.languages.index')); ?>"><?php echo e(__('Manage Language')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Edit Language')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Edit Language')); ?></h4>
                                <div>
                                    <a href="<?php echo e(route('admin.languages.index')); ?>" class="btn btn-primary"><i
                                            class="fa fa-arrow-left"></i><?php echo e(__('Back')); ?></a>
                                </div>
                            </div>
                            <div class="card-body">
                                <form action="<?php echo e(route('admin.languages.update', $language->id)); ?>"
                                    enctype="multipart/form-data" method="post">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="offset-md-3 col-md-6">
                                            <div class="form-group">
                                                <label for="name"><?php echo e(__('Name')); ?></label>
                                                <input type="text" class="form-control" name="name" id="name"
                                                    placeholder="<?php echo e(__('Enter Name')); ?>"
                                                    value="<?php echo e(old('name', $language->name)); ?>">
                                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="offset-md-3 col-md-6">
                                            <div class="form-group">
                                                <label for="code"><?php echo e(__('Code')); ?></label>
                                                <select class="form-control select2" name="code" id="code">
                                                    <option><?php echo e(__('Select language')); ?></option>
                                                    <?php $__currentLoopData = $all_languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($lang->code); ?>" <?php if(old('code', $language->code) == $lang->code): echo 'selected'; endif; ?>>
                                                            <?php echo e($lang->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        </div>
                                        <div class="text-center offset-md-3 col-md-6">
                                            <?php if (isset($component)) { $__componentOriginalf3ad9c349c70d58844f8581b0990debd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3ad9c349c70d58844f8581b0990debd = $attributes; } ?>
<?php $component = App\View\Components\Admin\UpdateButton::resolve(['text' => __('Update')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.update-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\UpdateButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $attributes = $__attributesOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $component = $__componentOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__componentOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Language\resources\views\edit.blade.php ENDPATH**/ ?>