<?php if(Module::isEnabled('Language') && Route::has('admin.course.index')): ?>
    <?php
        $pendingCourseCount = \App\Models\Course::where('is_approved', 'pending')->count();
    ?>
    <li
        class="nav-item dropdown <?php echo e(isRoute(['admin.courses.*', 'admin.course-category.*', 'admin.course-filter.*', 'admin.course-language.*', 'admin.course-level.*', 'admin.course-review.*', 'admin.course-delete-request.*', 'admin.course-sub-category.*'], 'active')); ?>">
        <a href="javascript:void()" class="nav-link has-dropdown"><i
                class="fas fa-graduation-cap"></i><span class="<?php echo e($pendingCourseCount > 0 ? 'beep parent' : ''); ?>"><?php echo e(__('Manage Courses')); ?></span></a>

        <ul class="dropdown-menu">
            <li class="<?php echo e(isRoute('admin.courses.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.courses.index')); ?>">
                    <?php echo e(__('Courses')); ?>

                    <?php if($pendingCourseCount > 0): ?>
                    <small class="badge badge-danger ml-2"><?php echo e($pendingCourseCount); ?></small>
                    <?php endif; ?>
                </a>
            </li>
            <li class="<?php echo e(isRoute('admin.course-category.*', 'active')); ?> <?php echo e(isRoute('admin.course-sub-category.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.course-category.index')); ?>">
                    <?php echo e(__('Categories')); ?>

                </a>
            </li>

            <li class="<?php echo e(isRoute('admin.course-language.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.course-language.index')); ?>">
                    <?php echo e(__('languages')); ?>

                </a>
            </li>

            <li class="<?php echo e(isRoute('admin.course-level.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.course-level.index')); ?>">
                    <?php echo e(__('levels')); ?>

                </a>
            </li>

            <li class="<?php echo e(isRoute('admin.course-review.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.course-review.index')); ?>">
                    <?php echo e(__('Course Reviews')); ?>

                </a>
            </li>
            <li class="<?php echo e(isRoute('admin.course-delete-request.*', 'active')); ?>">
                <a class="nav-link" href="<?php echo e(route('admin.course-delete-request.index')); ?>">
                    <?php echo e(__('Course Delete Requests')); ?>

                </a>
            </li>
        </ul>
    </li>
<?php endif; ?>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\Course\resources\views\sidebar.blade.php ENDPATH**/ ?>