<?php
    $header_admin = Auth::guard('admin')->user();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <link rel="shortcut icon" href="" type="image/x-icon">
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no" name="viewport">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="mode" content="<?php echo e(env('PROJECT_MODE') ?? 'LIVE'); ?>">
    <!-- Custom Meta -->
    <?php echo $__env->yieldContent('custom_meta'); ?>

    <?php echo $__env->yieldContent('title'); ?>
    <link rel="icon" href="<?php echo e(asset($setting->favicon)); ?>">
    <?php echo $__env->make('admin.partials.styles', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldContent('vite'); ?>
</head>

<body>
    <div id="app">
        <div class="main-wrapper">
            <div class="navbar-bg"></div>
            <nav class="navbar navbar-expand-lg main-navbar">
                <div class="mr-2 form-inline">
                    <ul class="mr-3 navbar-nav d-flex align-items-center">
                        <li><a href="#" data-toggle="sidebar" class="nav-link nav-link-lg"><i
                                    class="fas fa-bars"></i></a></li>
                        <li><a href="#" data-toggle="search" class="nav-link nav-link-lg d-none"><i
                                    class="fas fa-search"></i></a></li>
                        <?php if(Module::isEnabled('Language') && Route::has('set-language')): ?>
                            <?php if(count(allLanguages()?->where('status', 1)) > 1): ?>
                                <form id="setLanguageHeader" action="<?php echo e(route('set-language')); ?>">
                                    <select class="bg-transparent form-control-sm border-light select_js"
                                        name="code">
                                        <?php $__empty_1 = true; $__currentLoopData = allLanguages()?->where('status', 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <option class="text-dark" value="<?php echo e($language->code); ?>"
                                                <?php echo e(getSessionLanguage() == $language->code ? 'selected' : ''); ?>>
                                                <?php echo e($language->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <option value="en" <?php echo e(getSessionLanguage() == 'en' ? 'selected' : ''); ?>>
                                                English
                                            </option>
                                        <?php endif; ?>
                                    </select>
                                </form>
                            <?php endif; ?>
                        <?php endif; ?>

                        <?php if(count(allCurrencies()?->where('status', 'active')) > 1): ?>
                            <form action="<?php echo e(route('set-currency')); ?>" class="set-currency-header">
                                <select name="currency"
                                    class="change-currency bg-transparent form-control-sm border-light ml-2 select_js">
                                    <?php $__empty_1 = true; $__currentLoopData = allCurrencies()?->where('status', 'active'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <option class="text-dark" value="<?php echo e($currency->currency_code); ?>"
                                            <?php echo e(getSessionCurrency() == $currency->currency_code ? 'selected' : ''); ?>>
                                            <?php echo e($currency->currency_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <option value="USD" <?php echo e(getSessionCurrency() == 'USD' ? 'selected' : ''); ?>>
                                            <?php echo e(__('USD')); ?>

                                        </option>
                                    <?php endif; ?>
                                </select>
                            </form>
                        <?php endif; ?>
                    </ul>
                </div>
                <div class="mr-auto search-box position-relative">
                    <input type="text" id="search_menu" class="form-control"
                        placeholder="<?php echo e(__('Search options')); ?>">
                    <div id="admin_menu_list" class="position-absolute d-none rounded-2">
                        <?php $__currentLoopData = adminSearchRouteList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $route_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if(checkAdminHasPermission($route_item?->permission) || empty($route_item?->permission)): ?>
                                <a <?php if(isset($route_item->tab)): ?> 
                                        data-active-tab="<?php echo e($route_item->tab); ?>" class="border-bottom search-menu-item" 
                                    <?php else: ?> 
                                        class="border-bottom" 
                                    <?php endif; ?>
                                    href="<?php echo e($route_item?->route); ?>"><?php echo e($route_item?->name); ?></a>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <a class="not-found-message d-none" href="javascript:;"><?php echo e(__('Not Found!')); ?></a>
                    </div>
                </div>

                <ul class="navbar-nav navbar-right">
                    <li class="dropdown dropdown-list-toggle">
                        <a target="_blank" href="<?php echo e(route('home')); ?>" class="nav-link nav-link-lg">
                            <i class="fas fa-home"></i> <?php echo e(__('Visit Website')); ?></i>
                        </a>
                    </li>

                    <li class="dropdown"><a href="#" data-toggle="dropdown"
                            class="nav-link dropdown-toggle nav-link-lg nav-link-user">
                            <?php if($header_admin->image): ?>
                                <img alt="image" src="<?php echo e(asset($header_admin->image)); ?>"
                                    class="mr-1 rounded-circle">
                            <?php else: ?>
                                <img alt="image" src="" class="mr-1 rounded-circle">
                            <?php endif; ?>

                            <div class="d-sm-none d-lg-inline-block"><?php echo e($header_admin->name); ?></div>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a href="<?php echo e(route('admin.settings')); ?>" class="dropdown-item has-icon">
                                <i class="fas fa-cog"></i> <?php echo e(__('Settings')); ?>

                            </a>


                            <?php if(auth()->guard('admin')->user()->can('admin.profile.view')): ?>
                                <a href="<?php echo e(route('admin.edit-profile')); ?>" class="dropdown-item has-icon">
                                    <i class="far fa-user"></i> <?php echo e(__('Profile')); ?>

                                </a>
                            <?php endif; ?>
                            <a href="javascript:;" class="dropdown-item has-icon d-flex align-items-center text-danger"
                                onclick="event.preventDefault(); $('#admin-logout-form').trigger('submit');">
                                <i class="fas fa-sign-out-alt"></i> <?php echo e(__('Logout')); ?>

                            </a>
                        </div>
                    </li>

                </ul>
            </nav>

            <?php if(request()->routeIs(
                    'admin.general-setting',
                    'admin.marketing-setting',
                    'admin.commission-setting',
                    'admin.crediential-setting',
                    'admin.email-configuration',
                    'admin.edit-email-template',
                    'admin.currency.*',
                    'admin.seo-setting',
                    'admin.custom-code',
                    'admin.cache-clear',
                    'admin.database-clear',
                    'admin.system-update.index',
                    'admin.addons.*',
                    'admin.admin.*',
                    'admin.languages.*',
                    'admin.basicpayment',
                    'admin.paymentgateway',
                    'admin.role.*')): ?>
                <?php echo $__env->make('admin.settings.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php else: ?>
                <?php echo $__env->make('admin.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <?php echo $__env->yieldContent('admin-content'); ?>

            <footer class="main-footer">
                <div class="footer-left">
                    <?php echo e($setting->copyright_text); ?>

                </div>
                <div class="footer-right">
                    <span><?php echo e(__('version')); ?>: <?php echo e($setting->version ?? ''); ?></span>
                </div>
            </footer>

        </div>
    </div>

    
    <form id="admin-logout-form" action="<?php echo e(route('admin.logout')); ?>" method="POST" class="d-none">
        <?php echo csrf_field(); ?>
    </form>
    
    <?php echo $__env->make('admin.partials.modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('admin.partials.javascripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('global.dynamic-js-variables', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldPushContent('js'); ?>

</body>

</html>
<?php /**PATH D:\wamp64\www\brightfuture\resources\views\admin\master_layout.blade.php ENDPATH**/ ?>