<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Course Analytics')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1 class="text-primary"><?php echo e(__('Course')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Course Analytics')); ?></div>
                </div>
            </div>
            <div class="section-body">
                <div class="row">
                    <div class="col-12">
                        <?php echo $__env->make('course::course.navigation', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <form action="<?php echo e(route('admin.courses.update')); ?>"
                            class="instructor__profile-form course-form d-none">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="course_id" id="" value="<?php echo e($course?->id); ?>">
                            <input type="hidden" name="step" id="" value="4">
                            <input type="hidden" name="next_step" value="5">
                        </form>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Study Progress Tracker')); ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="chart-area">
                                    <canvas id="student_progress_chart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Sales In')); ?>

                                    <?php echo e(request()->has('year') ? Carbon\Carbon::createFromFormat('Y', request('year'))->format('Y') : date('Y')); ?>

                                </h4>
                                <div class="form-inline">
                                    <form method="get" onchange="$(this).trigger('submit');">
                                        <select name="year" id="year" class="form-control mb-0">
                                            <?php
                                                $currentYear = Carbon\Carbon::now()->year;
                                                $selectYear = request('year') ?? $currentYear;
                                            ?>
                                            <?php for($i = $oldestYear; $i <= $latestYear; $i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php if($selectYear == $i): echo 'selected'; endif; ?>>
                                                    <?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </form>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="chart-area">
                                    <canvas id="combined_monthly_chart"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .chart-area {
            min-height: 300px;
            max-height: 400px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('js'); ?>
    <script src="<?php echo e(asset('backend/js/default/courses.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/js/chart.umd.min.js')); ?>"></script>
    <script>
        (function($) {

            "use strict";

            // Area Chart Example
            $(document).ready(function() {

                renderOrderProgressChart();
                renderStudentProgressChart();
            });

        })(jQuery);

        function renderStudentProgressChart() {
            const progressRanges = <?php echo json_encode($progress_ranges, 15, 512) ?>;
            const labels = Object.keys(progressRanges).map(label => label + "%");
            const data = Object.values(progressRanges);

            var ctx = document.getElementById('student_progress_chart');
            var myLineChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: labels,
                    datasets: [{
                        label: "<?php echo e(__('Number of Students')); ?>",
                        lineTension: 0.3,
                        backgroundColor: "rgba(75, 192, 192, 0.2)",
                        borderColor: "rgba(75, 192, 192, 1)",
                        pointRadius: 3,
                        pointBackgroundColor: "rgba(78, 115, 223, 1)",
                        pointBorderColor: "rgba(78, 115, 223, 1)",
                        pointHoverRadius: 3,
                        pointHoverBackgroundColor: "rgba(78, 115, 223, 1)",
                        pointHoverBorderColor: "rgba(78, 115, 223, 1)",
                        pointHitRadius: 10,
                        pointBorderWidth: 2,
                        data: data,
                    }],
                },
                options: {
                    maintainAspectRatio: false,
                    responsive: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        x: {
                            title: {
                                display: true,
                                text: "<?php echo e(__('Completion Percentage Ranges')); ?>"
                            }
                        },
                        y: {
                            min: 0,
                            max: Math.max(...data),
                            ticks: {
                                beginAtZero: true,
                                stepSize: 1,
                                callback: function(value) {
                                    return value.toFixed(0);
                                }
                            }
                        }
                    }
                }
            });

        }

        function renderOrderProgressChart() {
            const date_labels = <?php echo json_encode($month_labels, 15, 512) ?>;
            const commission_monthly_data = <?php echo json_encode($commission_monthly_data, 15, 512) ?>;
            const net_monthly_data = <?php echo json_encode($net_monthly_data, 15, 512) ?>;
            const order_monthly_data = <?php echo json_encode($order_monthly_data, 15, 512) ?>;

            var ctx = document.getElementById('combined_monthly_chart');
            var myChart = new Chart(ctx, {
                type: 'bar',
                data: {
                    labels: date_labels,
                    datasets: [{
                            label: "<?php echo e(__('Order Summary')); ?>",
                            type: 'bar',
                            backgroundColor: "rgba(78, 115, 223, 0.7)",
                            borderColor: "rgba(78, 115, 223, 1)",
                            data: order_monthly_data,
                            order: 1,
                        },
                        {
                            label: "<?php echo e(__('Total Sales')); ?>",
                            type: 'line',
                            backgroundColor: "rgba(255, 205, 86, 1)",
                            borderColor: "rgba(255, 205, 86, 1)",
                            pointBackgroundColor: "rgba(255, 205, 86, 1)",
                            data: order_monthly_data,
                        },
                        {
                            label: "<?php echo e(__('Total Earnings')); ?>",
                            type: 'line',
                            backgroundColor: "rgba(40, 167, 69, 1)",
                            borderColor: "rgba(40, 167, 69, 1)",
                            pointBackgroundColor: "rgba(40, 167, 69, 1)",
                            data: net_monthly_data,
                        },
                        {
                            label: "<?php echo e(__('Admin Commission')); ?>",
                            type: 'line',
                            backgroundColor: "rgba(255, 99, 132, 1)",
                            borderColor: "rgba(255, 99, 132, 1)",
                            pointBackgroundColor: "rgba(255, 99, 132, 1)",
                            data: commission_monthly_data,
                        }
                    ],
                },
                options: {
                    maintainAspectRatio: false,
                    responsive: true,
                    layout: {
                        padding: {
                            left: 10,
                            right: 25,
                            top: 25,
                            bottom: 0
                        }
                    },
                    scales: {
                        y: {
                            min: 0,
                            ticks: {
                                beginAtZero: true,
                                color: "rgba(78, 115, 223, 1)",
                                callback: function(value) {
                                    return "<?php echo e(session()->get('currency_icon')); ?>" + number_format(value);
                                }
                            },
                        }
                    },
                    plugins: {
                        tooltip: {
                            callbacks: {
                                title: function(context) {
                                    return context[0].label;
                                },
                                label: function(context) {
                                    let currencyIcon = "<?php echo e(session()->get('currency_icon')); ?>";
                                    let sales = order_monthly_data[context.dataIndex] || 0;
                                    let commission = commission_monthly_data[context.dataIndex] || 0;
                                    let revenue = net_monthly_data[context.dataIndex] || 0;

                                    let datasetLabel = context.dataset.label;

                                    if (datasetLabel === "<?php echo e(__('Order Summary')); ?>") {
                                        return [
                                            "<?php echo e(__('Total Sales')); ?>: " + currencyIcon + number_format(
                                                sales),
                                            "<?php echo e(__('Total Earnings')); ?>: " + currencyIcon + number_format(
                                                revenue),
                                            "<?php echo e(__('Admin Commission')); ?>: " + currencyIcon +
                                            number_format(commission)
                                        ];
                                    }
                                    if (datasetLabel === "<?php echo e(__('Total Sales')); ?>") {
                                        return "<?php echo e(__('Total Sales')); ?>: " + currencyIcon + number_format(
                                            sales);
                                    } else if (datasetLabel === "<?php echo e(__('Total Earnings')); ?>") {
                                        return "<?php echo e(__('Total Earnings')); ?>: " + currencyIcon + number_format(
                                            revenue);
                                    } else if (datasetLabel === "<?php echo e(__('Admin Commission')); ?>") {
                                        return "<?php echo e(__('Admin Commission')); ?>: " + currencyIcon + number_format(
                                            commission);
                                    }
                                }
                            }
                        }
                    }
                }
            });
        }

        function number_format(number, decimals = 2, dec_point = '.', thousands_sep = ',') {
            number = parseFloat(number).toFixed(decimals);
            let parts = number.split('.');
            parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, thousands_sep);
            return parts.join(dec_point);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Course\resources\views\course\analytics.blade.php ENDPATH**/ ?>