<?php
    $method = $paymentMethod;
    $bank_information = $paymentService->getGatewayDetails($method)->bank_information ?? '';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Bank Checkout</title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo e(asset($setting->favicon)); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('frontend/css/main.min.css')); ?>?v=<?php echo e($setting?->version); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('global/toastr/toastr.min.css')); ?>">

</head>

<body>
    <section class="about-area-three section-py-120 vh-100 d-flex align-items-center justify-content-center">
        <div class="container d-flex justify-content-center">
            <div class="col-md-7">
                <div class="text-center mb-3">
                    <a href="<?php echo e(route('home')); ?>">
                        <img src="<?php echo e(asset($setting?->logo)); ?>" alt="<?php echo e($setting?->app_name); ?>" width="220">
                    </a>
                </div>
                <div class="card singUp-wrap">
                    <div class="card-header bg-transparent">
                        <?php echo nl2br($bank_information); ?>

                    </div>
                    <div class="card-body">
                        <form
                            action="<?php echo e(isset($token) ? route('payment-api.bank-webview', ['bearer_token' => $token, 'order_id' => $order_id]) : route('pay-via-bank')); ?>"
                            method="post">
                            <?php echo csrf_field(); ?>

                            <!-- Bank Name -->
                            <div class="my-1 form-group">
                                <label for="bank_name"><?php echo e(__('Bank Name')); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="bank_name" name="bank_name"
                                    placeholder="<?php echo e(__('Your bank name')); ?>">
                                    <?php $__errorArgs = ['bank_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Account Number -->
                            <div class="my-1 form-group">
                                <label for="account_number"><?php echo e(__('Account Number')); ?> <span
                                        class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="account_number" name="account_number"
                                    placeholder="<?php echo e(__('Your bank account number')); ?>">
                                    <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Routing Number -->
                            <div class="my-1 form-group">
                                <label for="transaction"><?php echo e(__('Transaction ID')); ?></label>
                                <input type="text" class="form-control" id="transaction" name="transaction"
                                    placeholder="<?php echo e(__('Your bank transaction ID')); ?>">
                                    <?php $__errorArgs = ['transaction'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Routing Number -->
                            <div class="my-1 form-group">
                                <label for="routing_number"><?php echo e(__('Routing Number')); ?></label>
                                <input type="text" class="form-control" id="routing_number" name="routing_number"
                                    placeholder="<?php echo e(__('Your bank routing number')); ?>">
                                    <?php $__errorArgs = ['routing_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <!-- Branch -->
                            <div class="my-1 form-group">
                                <label for="branch"><?php echo e(__('Branch')); ?> <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="branch" name="branch"
                                    placeholder="<?php echo e(__('Your bank branch name')); ?>">
                                    <?php $__errorArgs = ['branch'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <small class="text-danger"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <button class="mt-2 btn btn-primary"><?php echo e(__('Submit')); ?></button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- dynamic Toastr Notification -->
    <script src="<?php echo e(asset('global/toastr/toastr.min.js')); ?>"></script>
    <script>
        "use strict";
        toastr.options.closeButton = true;
        toastr.options.progressBar = true;
        toastr.options.positionClass = 'toast-bottom-right';

        <?php $__sessionArgs = ['messege'];
if (session()->has($__sessionArgs[0])) :
if (isset($value)) { $__sessionPrevious[] = $value; }
$value = session()->get($__sessionArgs[0]); ?>
        var type = "<?php echo e(Session::get('alert-type', 'info')); ?>"
        switch (type) {
            case 'info':
                toastr.info("<?php echo e($value); ?>");
                break;
            case 'success':
                toastr.success("<?php echo e($value); ?>");
                break;
            case 'warning':
                toastr.warning("<?php echo e($value); ?>");
                break;
            case 'error':
                toastr.error("<?php echo e($value); ?>");
                break;
        }
        <?php unset($value);
if (isset($__sessionPrevious) && !empty($__sessionPrevious)) { $value = array_pop($__sessionPrevious); }
if (isset($__sessionPrevious) && empty($__sessionPrevious)) { unset($__sessionPrevious); }
endif;
unset($__sessionArgs); ?>
    </script>
</body>

</html>
<?php /**PATH D:\wamp64\www\brightfuture\Modules\BasicPayment\resources\views\gateway-actions\bank.blade.php ENDPATH**/ ?>