<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('Edit Post')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1><?php echo e(__('Edit Post')); ?></h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                    </div>
                    <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.blogs.index')); ?>"><?php echo e(__('Blog List')); ?></a>
                    </div>
                    <div class="breadcrumb-item"><?php echo e(__('Edit Post')); ?> (<?php echo e(request('code')); ?>)</div>
                </div>
            </div>
            <div class="section-body row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="service_card"><?php echo e(__('Available Translations')); ?></h5>
                            <?php if(auth()->guard('admin')->user()->can('blog.translate')): ?>
                                <hr>
                                <?php if($code !== $languages->first()->code): ?>
                                    <button onclick="translateAll()" class="btn btn-primary"
                                        id="translate-btn"><?php echo e(__('Translate')); ?></button>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <div class="lang_list_top">
                                <ul class="lang_list">
                                    <?php $__currentLoopData = $languages = allLanguages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><a id="<?php echo e(request('code') == $language->code ? 'selected-language' : ''); ?>"
                                                href="<?php echo e(route('admin.blogs.edit', ['blog' => $blog->id, 'code' => $language->code])); ?>"><i
                                                    class="fas <?php echo e(request('code') == $language->code ? 'fa-eye' : 'fa-edit'); ?>"></i>
                                                <?php echo e($language->name); ?></a></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>

                            <div class="mt-2 alert alert-danger" role="alert">
                                <?php
                                    $current_language = $languages->where('code', request()->get('code'))->first();
                                ?>
                                <p><?php echo e(__('Your editing mode')); ?>:<b> <?php echo e($current_language?->name); ?></b></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="section-body">
                <div class="mt-4 row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between">
                                <h4><?php echo e(__('Edit Post')); ?></h4>
                                <div>
                                    <a href="<?php echo e(route('admin.blogs.index')); ?>" class="btn btn-primary"><i
                                            class="fa fa-arrow-left"></i><?php echo e(__('Back')); ?></a>
                                </div>
                            </div>
                            <div class="card-body">
                                <form
                                    action="<?php echo e(route('admin.blogs.update', [
                                        'blog' => $blog->id,
                                        'code' => $code,
                                    ])); ?>"
                                    method="POST" enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>

                                    <div class="row">
                                        <?php if($code == $languages->first()->code): ?>
                                            <div class="form-group col-md-8 offset-md-2">
                                                <label><?php echo e(__('Thumbnail Image')); ?> <code>(<?php echo e(__('Recommended')); ?>: 620X415 PX)</code></label>
                                                <div id="image-preview" class="image-preview"
                                                    <?php if($blog->image ?? false): ?> style="background-image: url(<?php echo e(asset($blog->image)); ?>); background-size: cover; background-position: center center;" <?php endif; ?>>
                                                    <label for="image-upload" id="image-label"><?php echo e(__('Image')); ?></label>
                                                    <input type="file" name="image" id="image-upload">
                                                </div>
                                                <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>
                                        <?php endif; ?>
                                        <div class="form-group col-md-8 offset-md-2">
                                            <label><?php echo e(__('Title')); ?> <span class="text-danger">*</span></label>
                                            <input data-translate="true" type="text" id="title" class="form-control"
                                                name="title" value="<?php echo e($blog->getTranslation($code)->title); ?>">
                                        </div>
                                        <?php if($code == $languages->first()->code): ?>
                                            <div class="form-group col-md-8 offset-md-2">
                                                <label><?php echo e(__('Slug')); ?> <span class="text-danger">*</span></label>
                                                <input type="text" id="slug" class="form-control" name="slug"
                                                    value="<?php echo e($blog->slug); ?>">
                                            </div>

                                            <div class="form-group col-md-8 offset-md-2">
                                                <label><?php echo e(__('Category')); ?> <span class="text-danger">*</span></label>
                                                <select name="blog_category_id" class="form-control select2" id="category">
                                                    <option value=""><?php echo e(__('Select Category')); ?></option>
                                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option
                                                        <?php echo e($category->id == old('blog_category_id', $blog->blog_category_id) ? 'selected' : ''); ?>

                                                            value="<?php echo e($category->id); ?>"><?php echo e($category->title); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        <?php endif; ?>
                                        <div class="form-group col-md-8 offset-md-2">
                                            <label><?php echo e(__('Description')); ?> <span class="text-danger">*</span></label>
                                            <textarea name="description" id="" cols="30" rows="10" class="summernote"><?php echo clean($blog->getTranslation($code)->description); ?></textarea>
                                        </div>
                                        <?php if($code == $languages->first()->code): ?>
                                            <div class="form-group col-md-8 offset-md-2">
                                                <label>
                                                    <input <?php echo e($blog->show_homepage == 1 ? 'checked' : ''); ?> type="checkbox"
                                                        value="1" name="show_homepage" class="custom-switch-input">
                                                    <span class="custom-switch-indicator"></span>
                                                    <span
                                                        class="custom-switch-description"><?php echo e(__('Show on homepage')); ?></span>
                                                </label>
                                            </div>

                                            <div class="form-group col-md-8 offset-md-2">
                                                <label>
                                                    <input <?php echo e($blog->is_popular == 1 ? 'checked' : ''); ?> type="checkbox"
                                                        value="1" name="is_popular" class="custom-switch-input">
                                                    <span class="custom-switch-indicator"></span>
                                                    <span
                                                        class="custom-switch-description"><?php echo e(__('Mark as a Popular')); ?></span>
                                                </label>
                                            </div>

                                            <div class="form-group col-md-8 offset-md-2">
                                                <label>
                                                    <input <?php echo e($blog->status == 1 ? 'checked' : ''); ?> type="checkbox"
                                                        value="1" name="status" class="custom-switch-input">
                                                    <span class="custom-switch-indicator"></span>
                                                    <span class="custom-switch-description"><?php echo e(__('Status')); ?></span>
                                                </label>
                                            </div>
                                            <div class="form-group col-md-8 offset-md-2">
                                                <label><?php echo e(__('Tags')); ?></label>
                                                <input type="text" class="form-control tags" name="tags"
                                                    value="<?php echo e($blog->tags); ?>">
                                            </div>
                                        <?php endif; ?>

                                        <div class="form-group col-md-8 offset-md-2">
                                            <label><?php echo e(__('SEO Title')); ?></label>
                                            <input data-translate="true" type="text" class="form-control"
                                                name="seo_title" value="<?php echo e($blog->getTranslation($code)->seo_title); ?>">
                                        </div>

                                        <div class="form-group col-md-8 offset-md-2">
                                            <label><?php echo e(__('SEO Description')); ?></label>
                                            <textarea data-translate="true" name="seo_description" id="" cols="30" rows="10"
                                                class="form-control text-area-5"><?php echo e($blog->getTranslation($code)->seo_description); ?></textarea>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="text-center col-md-8 offset-md-2">
                                            <?php if (isset($component)) { $__componentOriginalf3ad9c349c70d58844f8581b0990debd = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf3ad9c349c70d58844f8581b0990debd = $attributes; } ?>
<?php $component = App\View\Components\Admin\UpdateButton::resolve(['text' => __('Update')] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('admin.update-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\Admin\UpdateButton::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $attributes = $__attributesOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__attributesOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf3ad9c349c70d58844f8581b0990debd)): ?>
<?php $component = $__componentOriginalf3ad9c349c70d58844f8581b0990debd; ?>
<?php unset($__componentOriginalf3ad9c349c70d58844f8581b0990debd); ?>
<?php endif; ?>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <?php if($code == $languages->first()->code): ?>
        <script src="<?php echo e(asset('backend/js/jquery.uploadPreview.min.js')); ?>"></script>
        <script>
            $.uploadPreview({
                input_field: "#image-upload",
                preview_box: "#image-preview",
                label_field: "#image-label",
                label_default: "<?php echo e(__('Choose Image')); ?>",
                label_selected: "<?php echo e(__('Change Image')); ?>",
                no_label: false,
                success_callback: null
            });
        </script>
        <script>
            (function($) {
                "use strict";
                $(document).ready(function() {
                    $("#title").on("keyup", function(e) {
                        $("#slug").val(convertToSlug($(this).val()));
                    })
                });
            })(jQuery);

            function convertToSlug(Text) {
                return Text
                    .toLowerCase()
                    .replace(/[^\w ]+/g, '')
                    .replace(/ +/g, '-');
            }
        </script>
    <?php else: ?>
        <script>
            var isTranslatingInputs = true;

            function translateOneByOne(inputs, index = 0) {
                if (index >= inputs.length) {
                    if (isTranslatingInputs) {
                        isTranslatingInputs = false;
                        translateAllTextarea();
                    }
                    $('#translate-btn').prop('disabled', false);
                    $('#update-btn').prop('disabled', false);
                    return;
                }

                var $input = $(inputs[index]);
                var inputValue = $input.val();

                if (inputValue) {
                    $.ajax({
                        url: "<?php echo e(route('admin.languages.update.single')); ?>",
                        type: "POST",
                        data: {
                            lang: '<?php echo e($code); ?>',
                            text: inputValue,
                            _token: '<?php echo e(csrf_token()); ?>'
                        },
                        dataType: 'json',
                        beforeSend: function() {
                            $input.prop('disabled', true);
                            iziToast.show({
                                timeout: false,
                                close: true,
                                theme: 'dark',
                                icon: 'loader',
                                iconUrl: 'https://hub.izmirnic.com/Files/Images/loading.gif',
                                title: "<?php echo e(__('Translation Processing, please wait...')); ?>",
                                position: 'center',
                            });
                        },
                        success: function(response) {
                            $input.val(response);
                            $input.prop('disabled', false);
                            iziToast.destroy();
                            toastr.success("<?php echo e(__('Translated Successfully!')); ?>");
                            translateOneByOne(inputs, index + 1);
                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            console.error(textStatus, errorThrown);
                            iziToast.destroy();
                            toastr.error('Error', 'Error');
                        }
                    });
                } else {
                    translateOneByOne(inputs, index + 1);
                }
            }

            function translateAll() {
                iziToast.question({
                    timeout: 20000,
                    close: false,
                    overlay: true,
                    displayMode: 'once',
                    id: 'question',
                    zindex: 999,
                    title: "<?php echo e(__('This will take a while!')); ?>",
                    message: "<?php echo e(__('Are you sure?')); ?>",
                    position: 'center',
                    buttons: [
                        ["<button><b><?php echo e(__('YES')); ?></b></button>", function(instance, toast) {
                            var isDemo = "<?php echo e(env('PROJECT_MODE') ?? 1); ?>";

                            if (isDemo == 0) {
                                instance.hide({
                                    transitionOut: 'fadeOut'
                                }, toast, 'button');
                                toastr.error("<?php echo e(__('This Is Demo Version. You Can Not Change Anything')); ?>");
                                return;
                            }

                            $('#translate-btn').prop('disabled', true);
                            $('#update-btn').prop('disabled', true);

                            instance.hide({
                                transitionOut: 'fadeOut'
                            }, toast, 'button');

                            var inputs = $('input[data-translate="true"]').toArray();
                            translateOneByOne(inputs);

                        }, true],
                        ["<button><?php echo e(__('NO')); ?></button>", function(instance, toast) {

                            instance.hide({
                                transitionOut: 'fadeOut'
                            }, toast, 'button');

                        }],
                    ],
                    onClosing: function(instance, toast, closedBy) {},
                    onClosed: function(instance, toast, closedBy) {}
                });
            };

            function translateAllTextarea() {
                var inputs = $('textarea[data-translate="true"]').toArray();
                if (inputs.length === 0) {
                    return;
                }
                translateOneByOne(inputs);
            }

            $(document).ready(function() {
                var selectedTranslation = $('#selected-language').text();
                var btnText = "<?php echo e(__('Translate to')); ?> " + selectedTranslation;
                $('#translate-btn').text(btnText);
            });
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Blog\resources\views\Post\edit.blade.php ENDPATH**/ ?>