<?php $__env->startSection('dashboard-contents'); ?>
    <div class="dashboard__content-wrap">
        <div class="dashboard__content-title">
            <h4 class="title"><?php echo e(__('My Quiz Attempts')); ?></h4>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="dashboard__review-table table-responsive">
                    <table class="table table-borderless">
                        <thead>
                            <tr>
                                <th><?php echo e(__('No')); ?></th>
                                <th><?php echo e(__('Course')); ?></th>
                                <th><?php echo e(__('Quiz')); ?></th>
                                <th><?php echo e(__('Quiz Grade')); ?></th>
                                <th><?php echo e(__('My Grade')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Date')); ?></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php $__empty_1 = true; $__currentLoopData = $quizAttempts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attempt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(++$index); ?></td>
                                    <td><?php echo e($attempt->quiz->course?->title); ?></td>
                                    <td><?php echo e($attempt->quiz->title); ?></td>
                                   

                                    <td><?php echo e($attempt->quiz->total_mark); ?></td>
                                    <td><?php echo e($attempt->user_grade); ?></td>
                                    <td>
                                        <?php if($attempt->status == 'pass'): ?>
                                            <span class="badge bg-success"><?php echo e($attempt->status); ?></span>
                                        <?php else: ?>
                                            <span class="badge bg-danger"><?php echo e($attempt->status); ?></span>
                                        <?php endif; ?> 
                                    </td>

                                    <td>
                                        <?php echo e(formatDate($attempt->created_at)); ?>

                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('student.quiz.result', ['id' => $attempt->quiz->id, 'result_id' => $attempt->id])); ?>"><i class="fas fa-eye"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="10" class="text-center"><?php echo e(__('No data found!')); ?></td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <?php echo e($quizAttempts->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.student-dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\resources\views\frontend\student-dashboard\quiz-attempts\index.blade.php ENDPATH**/ ?>