<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between">
            <p>Minimum Requirements</p>
            <div>
                <a class="btn btn-outline-primary" href="<?php echo e(route('setup.verify')); ?>">&laquo; Back</a>
                <a class="btn btn-outline-primary <?php if(!session()->has('requirements-complete')): ?> disabled <?php endif; ?>" href="<?php echo e(route('setup.database')); ?>">Next &raquo;</a>
            </div>
        </div>
        <div class="card-body">
            <ul class="list-group">
                <?php $__currentLoopData = $checks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $check): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="list-group-item d-flex justify-content-between align-items-left">
                        <div>
                            <?php if(array_key_exists($key, $failedChecks)): ?>
                                <i class="fas fa-times text-danger fa-fw"></i>
                            <?php else: ?>
                                <i class="fa fa-check text-success fa-fw"></i>
                            <?php endif; ?>
                            <span><?php echo e(__('installer::setup.' . $key)); ?></span>
                        </div>
                        <?php if(array_key_exists($key, $failedChecks)): ?>
                            <span class="badge bg-danger rounded-pill"><?php echo e($failedChecks[$key]['message']); ?>

                                <?php if(isset($failedChecks[$key]['url'])): ?>
                                    <a href="<?php echo e($failedChecks[$key]['url']); ?>" class="text-warning" target="_blank"
                                        rel="noopener noreferrer">(!)</a>
                                <?php endif; ?>
                            </span>
                        <?php endif; ?>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <div class="d-flex justify-content-end align-items-center mt-3">
                <?php if($success): ?>
                    <a href="<?php echo e(route('setup.database')); ?>" class="btn btn-primary">
                        Next
                    </a>
                <?php else: ?>
                    <span class="text-danger text-small fw-bold me-2">Enable all extension then click reload
                        button</span>
                    <a href="<?php echo e(route('setup.database')); ?>" class="btn btn-success">
                        Reload <i class="fa fa-sync"></i>
                    </a>
                <?php endif; ?>
            </div>
        </div>
        <div class="card-footer text-center">
            <p>For script support, contact us at <a href="https://websolutionus.com/page/support"
                target="_blank" rel="noopener noreferrer">@websolutionus</a>. We're here to help. Thank you!</p>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('installer::app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\brightfuture\Modules\Installer\resources\views\requirements.blade.php ENDPATH**/ ?>